/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.collections.sequences;

import java.awt.Point;
import java.util.Vector;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunLinearEquations
extends JunDoubleMatrix {
    int[] solutionLocations = null;

    public JunLinearEquations(int n, int n2, double[] dArray) {
        super(n, n2, dArray);
    }

    public boolean isSolved() {
        return this.solutionLocations != null;
    }

    public double[] solution() {
        int n = this.unknownSize();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.solutionAt_(i);
        }
        return dArray;
    }

    public double solutionAt_(int n) {
        this.solve();
        return -this._doubleValueAt(this.solutionLocations[n], this.columnSize - 1);
    }

    public void solve() {
        int n;
        if (this.isSolved()) {
            return;
        }
        int n2 = this.unknownSize();
        Vector<Integer> vector = new Vector<Integer>(this.rowSize);
        for (int i = 0; i < this.rowSize; ++i) {
            vector.addElement(new Integer(i));
        }
        Vector<Integer> vector2 = new Vector<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            vector2.addElement(new Integer(i));
        }
        final Vector<Integer> vector3 = vector;
        final Vector<Integer> vector4 = vector2;
        final JunLinearEquations junLinearEquations = this;
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value() {
                Point point = null;
                double d = -1.0;
                for (int i = 0; i < vector3.size(); ++i) {
                    int n = (Integer)vector3.elementAt(i);
                    for (int j = 0; j < vector4.size(); ++j) {
                        int n2 = (Integer)vector4.elementAt(j);
                        double d2 = Math.abs(junLinearEquations._doubleValueAt(n, n2));
                        if (!(d2 >= d)) continue;
                        point = new Point(n, n2);
                        d = d2;
                    }
                }
                if (point != null) {
                    vector3.removeElement(new Integer(point.x));
                    vector4.removeElement(new Integer(point.y));
                }
                return point;
            }
        };
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_(Object object) {
                Point point = (Point)object;
                for (int i = 0; i < junLinearEquations.rowSize(); ++i) {
                    int n;
                    double d = junLinearEquations._doubleValueAt(i, point.y) / junLinearEquations._doubleValueAt(point.x, point.y);
                    if (i == point.x || d == 0.0) continue;
                    for (n = 0; n < point.y; ++n) {
                        junLinearEquations._doubleValuePut(i, n, junLinearEquations._doubleValueAt(i, n) - junLinearEquations._doubleValueAt(point.x, n) * d);
                    }
                    junLinearEquations._doubleValuePut(i, point.y, 0.0);
                    for (n = point.y + 1; n < junLinearEquations.columnSize(); ++n) {
                        junLinearEquations._doubleValuePut(i, n, junLinearEquations._doubleValueAt(i, n) - junLinearEquations._doubleValueAt(point.x, n) * d);
                    }
                }
                return null;
            }
        };
        this.solutionLocations = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.solutionLocations[n] = -1;
        }
        for (n = 0; n < n2; ++n) {
            Point point = (Point)stBlockClosure.value();
            if (point == null || this._doubleValueAt(point.x, point.y) == 0.0) continue;
            stBlockClosure2.value_((Object)point);
            this.solutionLocations[point.y] = point.x;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.solutionLocations[n];
            if (n3 < 0) continue;
            this._doubleValuePut(n3, this.columnSize - 1, this._doubleValueAt(n3, this.columnSize - 1) / this._doubleValueAt(n3, n));
            this._doubleValuePut(n3, n, 1.0);
        }
    }

    public int unknownSize() {
        return this.columnSize - 1;
    }
}

