/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.collections.sequences;

import java.awt.Color;
import java.awt.Point;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

public class JunDoubleMatrix
extends JunMatrix {
    protected static StSymbol DefalutInverseCalculationMethod = JunDoubleMatrix.$((String)"GaussElimination");

    public JunDoubleMatrix(int n) {
        super(n);
    }

    public JunDoubleMatrix(int n, double[] dArray) {
        super(n);
        this.collection_(dArray);
    }

    public JunDoubleMatrix(int n, int n2) {
        super(n, n2);
    }

    public JunDoubleMatrix(int n, int n2, double[] dArray) {
        super(n, n2);
        this.collection_(dArray);
    }

    public JunDoubleMatrix(StDisplayable stDisplayable) {
        this(stDisplayable, new StBlockClosure(){

            public Object value_(Object object) {
                return new Double(StColorValue._GetLuminance((Color)((Color)object)));
            }
        });
    }

    public JunDoubleMatrix(StDisplayable stDisplayable, StBlockClosure stBlockClosure) {
        this(stDisplayable.bounds().width, stDisplayable.bounds().height);
        StImage stImage = stDisplayable.asImage();
        int n = stImage.width();
        int n2 = stImage.height();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Color color = new Color(stImage.getPixel(j, i));
                Double d = (Double)stBlockClosure.value_((Object)color);
                this.row_column_put_(j, i, d);
            }
        }
    }

    public static JunDoubleMatrix Unit_(Class clazz, int n) {
        JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)((Object)JunDoubleMatrix._New((Class)clazz, (Object)new Integer(n)));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                junDoubleMatrix._put(i, j, new Double(i == j ? 1.0 : 0.0));
            }
        }
        return junDoubleMatrix;
    }

    public static void CalculateInverseByGaussElimination() {
        JunDoubleMatrix.DefaultInverseCalculationMethod_(JunDoubleMatrix.$((String)"GaussElimination"));
    }

    public static void CalculateInverseByLuDecomposition() {
        JunDoubleMatrix.DefaultInverseCalculationMethod_(JunDoubleMatrix.$((String)"LuDecomposition"));
    }

    public static StSymbol DefaultInverseCalculationMethod() {
        return DefalutInverseCalculationMethod;
    }

    protected static void DefaultInverseCalculationMethod_(StSymbol stSymbol) {
        DefalutInverseCalculationMethod = stSymbol;
    }

    public double _doubleValueAt(int n, int n2) {
        return (Double)this._at(n, n2);
    }

    public void _doubleValuePut(int n, int n2, double d) {
        super._put(n, n2, new Double(d));
    }

    public double[] _doubleValuesBasicAt_(int n) {
        Object[] objectArray = this.atRow_(n);
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            dArray[i] = (Double)objectArray[i];
        }
        return dArray;
    }

    public void atAllPut_(double d) {
        super.atAllPut_(new Double(d));
    }

    public void atPoint_put_(Point point, double d) {
        this._doubleValuePut(point.x, point.y, d);
    }

    public void basicAt_put_(int n, double[] dArray) {
        Object[] objectArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new Double(dArray[i]);
        }
        this.atRow_put_(n, objectArray);
    }

    public void collection_(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                this._matrix[i][j] = new Double(dArray[n]);
                ++n;
            }
        }
    }

    public void row_column_put_(int n, int n2, double d) {
        this._doubleValuePut(n, n2, d);
    }

    public double[] asArrayOfDouble() {
        double[] dArray = new double[this.rowSize * this.columnSize];
        int n = 0;
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                dArray[n] = this._doubleValueAt(i, j);
                ++n;
            }
        }
        return dArray;
    }

    public StImage asImage() {
        return this.asImageColorBlock_(new StBlockClosure(){

            public Object value_(Object object) {
                return StColorValue.Brightness_((double)Math.max(0.0, Math.min(((Number)object).doubleValue(), 1.0)));
            }
        });
    }

    public StImage asImageColorBlock_(final StBlockClosure stBlockClosure) {
        final StImage stImage = new StImage(this.rowSize(), this.columnSize());
        this.doIJ_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Color color = (Color)stBlockClosure.value_(object);
                stImage.setPixel(((Number)object2).intValue(), ((Number)object3).intValue(), color.getRGB());
                return null;
            }
        });
        return stImage;
    }

    public JunDoubleMatrix _plus(JunDoubleMatrix junDoubleMatrix) {
        JunDoubleMatrix junDoubleMatrix2 = (JunDoubleMatrix)this.copy();
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                junDoubleMatrix2._doubleValuePut(i, j, junDoubleMatrix2._doubleValueAt(i, j) + junDoubleMatrix._doubleValueAt(i, j));
            }
        }
        return junDoubleMatrix2;
    }

    protected Object _calculateProductElementAt(int n, int n2, JunMatrix junMatrix) {
        final int n3 = n2;
        final JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)junMatrix;
        final StValueHolder stValueHolder = new StValueHolder(0);
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                double d = stValueHolder._doubleValue();
                double d2 = (Double)object;
                double d3 = junDoubleMatrix._doubleValueAt((Integer)object2, n3);
                stValueHolder.value_(d += d2 * d3);
                return null;
            }
        };
        this.rowIndex_doJ_(n, stBlockClosure);
        return stValueHolder.value();
    }

    public JunDoubleMatrix inverse() {
        if (this.inverseCalculationMethod() == JunDoubleMatrix.$((String)"GaussElimination")) {
            return this.inverseByGaussElimination();
        }
        if (this.inverseCalculationMethod() == JunDoubleMatrix.$((String)"LuDecomposition")) {
            return this.inverseByLuDecomposition();
        }
        return this.inverseByGaussElimination();
    }

    public JunDoubleMatrix inverseByGaussElimination() {
        if (!this.isSquare()) {
            throw SmalltalkException.Error((String)"the matrix is not square.");
        }
        JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)this.copy();
        JunDoubleMatrix junDoubleMatrix2 = JunDoubleMatrix.Unit_(JunDoubleMatrix.class, this.rowSize);
        for (int i = 0; i < this.columnSize; ++i) {
            JunDoubleMatrix junDoubleMatrix3;
            JunDoubleMatrix junDoubleMatrix4;
            int n;
            double d = junDoubleMatrix._doubleValueAt(i, i);
            if (d == 0.0) {
                n = i;
                while (d == 0.0 && n < this.rowSize) {
                    d = junDoubleMatrix._doubleValueAt(++n, i);
                }
                if (d != 0.0) {
                    d = 1.0 / d;
                }
                final int n2 = i;
                final int n3 = n;
                final double d2 = d;
                junDoubleMatrix4 = junDoubleMatrix;
                junDoubleMatrix.rowIndex_doJ_(i, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object;
                        int n = (Integer)object2;
                        double d22 = d + junDoubleMatrix4._doubleValueAt(n3, n) * d2;
                        junDoubleMatrix4._doubleValuePut(n2, n, d22);
                        return null;
                    }
                });
                junDoubleMatrix3 = junDoubleMatrix2;
                junDoubleMatrix2.rowIndex_doJ_(i, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object;
                        int n = (Integer)object2;
                        double d22 = d + junDoubleMatrix3._doubleValueAt(n3, n) * d2;
                        junDoubleMatrix3._doubleValuePut(n2, n, d22);
                        return null;
                    }
                });
            } else {
                n = i;
                final double d3 = d;
                final JunDoubleMatrix junDoubleMatrix5 = junDoubleMatrix;
                junDoubleMatrix.rowIndex_doJ_(i, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object / d3;
                        junDoubleMatrix5._doubleValuePut(n, (Integer)object2, d);
                        return null;
                    }
                });
                final JunDoubleMatrix junDoubleMatrix6 = junDoubleMatrix2;
                junDoubleMatrix2.rowIndex_doJ_(i, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object / d3;
                        junDoubleMatrix6._doubleValuePut(n, (Integer)object2, d);
                        return null;
                    }
                });
            }
            for (n = 0; n < this.rowSize; ++n) {
                if (n == i) continue;
                final double d4 = junDoubleMatrix._doubleValueAt(n, i);
                final int n4 = i;
                final int n5 = n;
                junDoubleMatrix4 = junDoubleMatrix;
                junDoubleMatrix.rowIndex_doJ_(n, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object;
                        int n = (Integer)object2;
                        double d2 = d - junDoubleMatrix4._doubleValueAt(n4, n) * d4;
                        junDoubleMatrix4._doubleValuePut(n5, n, d2);
                        return null;
                    }
                });
                junDoubleMatrix3 = junDoubleMatrix2;
                junDoubleMatrix2.rowIndex_doJ_(n, new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        double d = (Double)object;
                        int n = (Integer)object2;
                        double d2 = d - junDoubleMatrix3._doubleValueAt(n4, n) * d4;
                        junDoubleMatrix3._doubleValuePut(n5, n, d2);
                        return null;
                    }
                });
            }
        }
        return junDoubleMatrix2;
    }

    public JunDoubleMatrix inverseByLuDecomposition() {
        if (!this.isSquare()) {
            throw SmalltalkException.Error((String)"the matrix is not square.");
        }
        Object[] objectArray = this.luDecompose();
        if (objectArray == null) {
            throw SmalltalkException.Error((String)"the matrix is singular.");
        }
        JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)((Object)objectArray[0]);
        int[] nArray = (int[])objectArray[1];
        int n = this.rowSize();
        JunDoubleMatrix junDoubleMatrix2 = new JunDoubleMatrix(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            double d;
            int n3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = nArray[n4];
                d = n3 == i ? 1.0 : 0.0;
                for (n2 = 0; n2 < n4; ++n2) {
                    d -= junDoubleMatrix._doubleValueAt(n3, n2) * junDoubleMatrix2._doubleValueAt(n2, i);
                }
                junDoubleMatrix2._doubleValuePut(n4, i, d);
            }
            for (n4 = n - 1; n4 >= 0; --n4) {
                n3 = nArray[n4];
                d = junDoubleMatrix2._doubleValueAt(n4, i);
                for (n2 = n4 + 1; n2 < n; ++n2) {
                    d -= junDoubleMatrix._doubleValueAt(n3, n2) * junDoubleMatrix2._doubleValueAt(n2, i);
                }
                junDoubleMatrix2._doubleValuePut(n4, i, d / junDoubleMatrix._doubleValueAt(n3, n4));
            }
        }
        return junDoubleMatrix2;
    }

    protected StSymbol inverseCalculationMethod() {
        return JunDoubleMatrix.DefaultInverseCalculationMethod();
    }

    protected Object[] luDecompose() {
        double d;
        int n;
        double d2;
        int n2;
        if (!this.isSquare()) {
            throw SmalltalkException.Error((String)"the matrix is not square.");
        }
        int n3 = this.rowSize();
        double[] dArray = new double[n3];
        int[] nArray = new int[n3];
        JunDoubleMatrix junDoubleMatrix = (JunDoubleMatrix)this.copy();
        double d3 = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d2 = 0.0;
            for (n = 0; n < n3; ++n) {
                d = Math.abs(junDoubleMatrix._doubleValueAt(n2, n));
                if (!(d2 < d)) continue;
                d2 = d;
            }
            if (d2 == 0.0) {
                return null;
            }
            dArray[n2] = 1.0 / d2;
            nArray[n2] = n2;
        }
        n2 = -1;
        for (n = 0; n < n3; ++n) {
            double d4;
            int n4;
            d2 = -1.0;
            for (n4 = n; n4 < n3; ++n4) {
                int n5 = nArray[n4];
                d = Math.abs(junDoubleMatrix._doubleValueAt(n5, n)) * dArray[n5];
                if (!(d > d2)) continue;
                d2 = d;
                n2 = n4;
            }
            n4 = nArray[n2];
            if (n2 != n) {
                nArray[n2] = nArray[n];
                nArray[n] = n4;
                d3 = -d3;
            }
            if ((d4 = junDoubleMatrix._doubleValueAt(n4, n)) == 0.0) {
                return null;
            }
            d3 *= d4;
            for (int i = n + 1; i < n3; ++i) {
                d = junDoubleMatrix._doubleValueAt(nArray[i], n);
                junDoubleMatrix._doubleValuePut(nArray[i], n, d /= d4);
                for (int j = n + 1; j < n3; ++j) {
                    junDoubleMatrix._doubleValuePut(nArray[i], j, junDoubleMatrix._doubleValueAt(nArray[i], j) - d * junDoubleMatrix._doubleValueAt(n4, j));
                }
            }
        }
        return new Object[]{junDoubleMatrix, nArray, new Double(d3)};
    }
}

