/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.gl4jun;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import jp.co.sra.gl4jun.GLjImageSource;
import jp.co.sra.gl4jun.GLjInterface;

public class GLjRenderingContext {
    private static final int MEDIUM_IMAGE = 1;
    private static final int MEDIUM_CANVAS = 2;
    private static final int MEDIUM_JCANVAS = 3;
    protected static GLjInterface OpenGLInterface = GLjInterface.Current();
    private int mode;
    private Component heavy;
    private Object medium;
    private int medium_type;
    private int handle;
    private int[] pixels;
    private int width;
    private int height;

    public GLjRenderingContext(Canvas canvas) {
        this.mode = 4;
        this.heavy = canvas;
        this.medium = canvas;
        this.medium_type = 2;
    }

    public GLjRenderingContext(Container container, Frame frame) {
        this.mode = 2;
        this.heavy = frame;
        this.medium = container;
        this.medium_type = 3;
    }

    public GLjRenderingContext(GLjImageSource gLjImageSource) {
        this.mode = 2;
        this.heavy = null;
        this.medium = gLjImageSource;
        this.medium_type = 1;
    }

    public static final GLjInterface OpenGLInterface() {
        return OpenGLInterface;
    }

    public Color getBackground() {
        Color color;
        switch (this.medium_type) {
            case 1: {
                GLjImageSource gLjImageSource = (GLjImageSource)this.medium;
                color = gLjImageSource.getBackground();
                break;
            }
            case 2: 
            case 3: {
                Component component = (Component)this.medium;
                color = component.getBackground();
                break;
            }
            default: {
                color = null;
            }
        }
        return color;
    }

    public int getMode() {
        return this.mode;
    }

    public Dimension getSize() {
        Dimension dimension;
        switch (this.medium_type) {
            case 1: {
                GLjImageSource gLjImageSource = (GLjImageSource)this.medium;
                dimension = gLjImageSource.getSize();
                break;
            }
            case 2: 
            case 3: {
                Component component = (Component)this.medium;
                dimension = component.getSize();
                break;
            }
            default: {
                dimension = null;
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljCurrent() {
        if (this.mode == 0) {
            return;
        }
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            OpenGLInterface.gljMakeCurrent(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljDelete(boolean bl) {
        if (this.mode == 0) {
            return;
        }
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            OpenGLInterface.gljDeleteContext(this.handle, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljFlush() {
        Object object;
        if (this.mode == 0) {
            return;
        }
        if (this.medium_type == 1) {
            object = this.gljImageRGB();
            GLjImageSource gLjImageSource = (GLjImageSource)this.medium;
            gLjImageSource.setImage((Image)object);
        }
        object = OpenGLInterface;
        synchronized (object) {
            OpenGLInterface.gljFlushBuffer(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image gljImageRGB() {
        if (this.mode == 0) {
            return null;
        }
        Object object = OpenGLInterface;
        synchronized (object) {
            OpenGLInterface.gljReadImage(this.handle, this.pixels, false);
        }
        object = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createImage((ImageProducer)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image gljImageRGBA() {
        if (this.mode == 0) {
            return null;
        }
        Object object = OpenGLInterface;
        synchronized (object) {
            OpenGLInterface.gljReadImage(this.handle, this.pixels, true);
        }
        object = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createImage((ImageProducer)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljInitialize() {
        if (this.mode == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            this.handle = OpenGLInterface.gljCreateContext(this.heavy, dimension.width, dimension.height, this.mode);
            if (this.handle == 0) {
                this.mode = 2;
                this.handle = OpenGLInterface.gljCreateContext(this.heavy, dimension.width, dimension.height, this.mode);
                System.out.println("Can't get a drawable, the rendering mode is changed to IMAGE.");
            }
        }
        if (this.mode == 2) {
            this.width = dimension.width;
            this.height = dimension.height;
            this.pixels = new int[this.width * this.height];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljRelease() {
        if (this.mode == 0) {
            return;
        }
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            OpenGLInterface.gljDeleteContext(this.handle, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljResize(Dimension dimension) {
        if (this.mode == 0) {
            return;
        }
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            OpenGLInterface.gljSetSize(this.handle, dimension.width, dimension.height);
        }
        if (this.mode == 2) {
            this.width = dimension.width;
            this.height = dimension.height;
            this.pixels = new int[this.width * this.height];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gljSetLocation(Point point) {
        if (this.mode == 0) {
            return;
        }
        GLjInterface gLjInterface = OpenGLInterface;
        synchronized (gLjInterface) {
            OpenGLInterface.gljSetLocation(this.handle, point.x, point.y);
        }
    }

    public void setMode(int n) {
        boolean bl = true;
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            case 3: {
                if (this.medium_type != 1) break;
                bl = false;
                break;
            }
            case 1: 
            case 4: {
                if (this.medium_type != 1 && this.medium_type != 3) break;
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.mode = n;
        }
    }
}

