/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.gl4jun;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import jp.co.sra.gl4jun.GLjInterface;
import jp.co.sra.gl4jun.GLjRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;

public class GLjCanvas
extends Canvas {
    protected int renderingMode;
    protected transient GLjRenderingContext renderingContext;
    protected transient boolean resizeRequest;

    public GLjCanvas() {
        this.initialize();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GLjCanvas.this.resizeRequest = true;
            }
        });
    }

    protected void initialize() {
        this.renderingMode = 4;
        this.renderingContext = null;
        this.resizeRequest = false;
    }

    public void removeNotify() {
        if (this.renderingContext != null) {
            Container container;
            for (container = this.getParent(); container != null && !(container instanceof Applet); container = container.getParent()) {
            }
            this.renderingContext.gljDelete(container != null);
            this.renderingContext = null;
        }
        super.removeNotify();
    }

    public void setRenderingMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.renderingMode = n;
                break;
            }
            default: {
                throw new SmalltalkException("Invalid rendering mode : " + n);
            }
        }
    }

    protected GLjRenderingContext defaultRenderingContext() {
        return new GLjRenderingContext(this);
    }

    public void paint(Graphics graphics) {
        this.render(graphics);
        this.superimposeOn(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        GLjInterface gLjInterface = GLjInterface.Current();
        synchronized (gLjInterface) {
            if (this.renderingContext == null) {
                this.renderingContext = this.defaultRenderingContext();
                this.renderingContext.setMode(this.renderingMode);
                this.resizeRequest = false;
                this.renderingContext.gljInitialize();
            }
        }
        if (this.renderingContext.getMode() != 0) {
            GLjCanvas gLjCanvas = this;
            gLjInterface = gLjCanvas.renderingContext.OpenGLInterface();
            synchronized (gLjInterface) {
                if (this.resizeRequest) {
                    this.renderingContext.gljResize(this.getSize());
                    this.resizeRequest = false;
                }
                this.renderingContext.gljCurrent();
                this.render(this.renderingContext);
                if (this.renderingContext.getMode() == 2) {
                    Image image = this.renderingContext.gljImageRGB();
                    graphics.drawImage(image, 0, 0, null);
                }
                this.renderingContext.gljFlush();
            }
        }
    }

    protected void render(GLjRenderingContext gLjRenderingContext) {
        this.render(gLjRenderingContext.OpenGLInterface());
    }

    protected void render(GLjInterface gLjInterface) {
    }

    protected void superimposeOn(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

