/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;

public class LogUtilities {
    
    private static final Logger logger = Logger.getLogger(LogUtilities.class.getName());
    
    // Logging stuff    
    private static File logDir;
    private static File auditDir;
    private static String auditDirPath;


    /**
     * The console level (also used by the JMXHandler if present)
     */
    private static Level consoleLevel;
    
    /** Creates a new instance of LogUtilities */
    private LogUtilities() {
    }

    public static Logger getLogger(){
        return logger;
    }    
    
    private static boolean JDIFFCHASERLOGS_CONFIGURED = false;
 
    public static void configureSimpleConsoleLogs(String levelConsoleHandler){
        if(!JDIFFCHASERLOGS_CONFIGURED){
            getRootLogger().setLevel(Level.FINEST);
            getRootLogger().setUseParentHandlers(false);                       
            try{
                LogUtilities.consoleLevel = Level.parse(levelConsoleHandler);

                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(consoleLevel);            
                consoleHandler.setFormatter(LogFormatter.getInstance());            
                getRootLogger().addHandler(consoleHandler);

                FileHandler fileHandler = new FileHandler("jdiffchaser_%g.log", 
                                                          3000000, 10, true);
                fileHandler.setLevel(consoleLevel);            
                fileHandler.setFormatter(LogFormatter.getInstance());       
                getRootLogger().addHandler(fileHandler);            

            }catch(Exception exc){
                exc.printStackTrace();
            }                        
            JDIFFCHASERLOGS_CONFIGURED = true;
        }
    }
    
    private static final Logger getRootLogger(){
        Logger root = logger;
        while( root.getParent()!=null ){
            root = root.getParent();
        }
        return root;
    }
    
}
