/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ProfileProviderException;
import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.generic.ProfileServerProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ProfileServerFactory {
    public static final String PROFILE_PROVIDER_PACKAGES = "jmx.remote.profile.provider.pkgs";
    public static final String PROFILE_PROVIDER_CLASS_LOADER = "jmx.remote.profile.provider.class.loader";
    private static final String PROFILE_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.profile";
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileServerProvider;
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileServerFactory;

    private ProfileServerFactory() {
    }

    public static ProfileServer createProfile(String profile, Map environment) throws ProfileProviderException {
        String pkgs = ProfileServerFactory.resolvePkgs(environment);
        ClassLoader loader = ProfileServerFactory.resolveClassLoader(environment);
        environment = environment == null ? new HashMap<String, ClassLoader>() : new HashMap(environment);
        environment.put(PROFILE_PROVIDER_CLASS_LOADER, loader);
        environment = Collections.unmodifiableMap(environment);
        ProfileServerProvider provider = ProfileServerFactory.getProvider(profile, pkgs, loader);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported profile: " + profile);
        }
        return provider.createProfile(profile, environment);
    }

    private static final String resolvePkgs(Map env) {
        String pkgs = null;
        if (env != null) {
            pkgs = (String)env.get(PROFILE_PROVIDER_PACKAGES);
        }
        if (pkgs == null) {
            pkgs = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ProfileServerFactory.PROFILE_PROVIDER_PACKAGES);
                }
            });
        }
        pkgs = pkgs == null || pkgs.trim().equals("") ? PROFILE_PROVIDER_DEFAULT_PACKAGE : pkgs + "|com.sun.jmx.remote.profile";
        return pkgs;
    }

    private static final ProfileServerProvider getProvider(String profile, String pkgs, ClassLoader loader) throws ProfileProviderException {
        Class<?> providerClass = null;
        Object provider = null;
        Object obj = null;
        StringTokenizer tokenizer = new StringTokenizer(pkgs, "|");
        String p = profile.toLowerCase();
        if (p.indexOf("/") != -1) {
            p = p.substring(0, p.indexOf("/"));
        }
        while (tokenizer.hasMoreTokens()) {
            String pkg = tokenizer.nextToken();
            String className = pkg + "." + p + ".ServerProvider";
            try {
                providerClass = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                obj = providerClass.newInstance();
            }
            catch (Exception e) {
                String msg = "Exception when instantiating provider [" + className + "]";
                throw new ProfileProviderException(msg, e);
            }
            if (!(obj instanceof ProfileServerProvider)) {
                String msg = "Provider not an instance of " + (class$com$sun$jmx$remote$generic$ProfileServerProvider == null ? (class$com$sun$jmx$remote$generic$ProfileServerProvider = ProfileServerFactory.class$("com.sun.jmx.remote.generic.ProfileServerProvider")) : class$com$sun$jmx$remote$generic$ProfileServerProvider).getName() + ": " + obj.getClass().getName();
                throw new IllegalArgumentException(msg);
            }
            return (ProfileServerProvider)obj;
        }
        return null;
    }

    private static final ClassLoader resolveClassLoader(Map environment) {
        ClassLoader loader = null;
        if (environment != null) {
            try {
                loader = (ClassLoader)environment.get(PROFILE_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException e) {
                String msg = "ClassLoader not an instance of java.lang.ClassLoader : " + loader.getClass().getName();
                throw new IllegalArgumentException(msg);
            }
        }
        if (loader == null) {
            loader = (class$com$sun$jmx$remote$generic$ProfileServerFactory == null ? (class$com$sun$jmx$remote$generic$ProfileServerFactory = ProfileServerFactory.class$("com.sun.jmx.remote.generic.ProfileServerFactory")) : class$com$sun$jmx$remote$generic$ProfileServerFactory).getClassLoader();
        }
        return loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

