/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pointer {
    public static final int SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final Pointer NULL;
    public static final Pointer PM1;
    long peer;

    private static String getNativeLibraryResourcePath() {
        String arch = System.getProperty("os.arch");
        String osPrefix = Platform.isWindows() ? "win32-" + arch : (Platform.isMac() ? "darwin-" + arch : (Platform.isLinux() ? "linux-" + arch : (Platform.isSolaris() ? "sunos-" + arch : System.getProperty("os.name"))));
        return "/com/sun/jna/" + osPrefix;
    }

    /*
     * Loose catch block
     */
    private static boolean loadNativeLibrary() {
        File lib;
        block22: {
            int count;
            String resourceName;
            String libname = System.mapLibraryName("jnidispatch");
            URL url = Pointer.class.getResource(resourceName = Pointer.getNativeLibraryResourcePath() + "/" + libname);
            if (url == null) {
                System.err.println("Warning: jnidispatch (" + resourceName + ") not found in resource path");
                return false;
            }
            lib = null;
            if (url.getProtocol().toLowerCase().equals("file")) {
                try {
                    lib = new File(URLDecoder.decode(url.getPath(), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("JRE is unexpectedly missing UTF8 encoding");
                }
            }
            InputStream is = Pointer.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            String ext = libname.substring(libname.lastIndexOf("."));
            lib = File.createTempFile("jna", ext);
            lib.deleteOnExit();
            fos = new FileOutputStream(lib);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
            Object var10_12 = null;
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            break block22;
            {
                catch (IOException e) {
                    throw new Error("Failed to create temporary file for jnidispatch library", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (Platform.isWindows()) {
            Toolkit.getDefaultToolkit();
            try {
                System.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
        }
        System.load(lib.getAbsolutePath());
        return true;
    }

    private static native int initIDs();

    private static native int longSize();

    private static native int wideCharSize();

    Pointer() {
    }

    Pointer(long peer) {
        this.peer = peer;
    }

    Pointer share(int offset, int sz) {
        return new Pointer(this.peer + (long)offset);
    }

    void clear(int size) {
        byte[] buffer = new byte[size];
        this.write(0, buffer, 0, size);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return this.peer == 0L;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean isValid() {
        return this.peer != 0L;
    }

    public native int indexOf(int var1, byte var2);

    public native void read(int var1, byte[] var2, int var3, int var4);

    public native void read(int var1, short[] var2, int var3, int var4);

    public native void read(int var1, char[] var2, int var3, int var4);

    public native void read(int var1, int[] var2, int var3, int var4);

    public native void read(int var1, long[] var2, int var3, int var4);

    public native void read(int var1, float[] var2, int var3, int var4);

    public native void read(int var1, double[] var2, int var3, int var4);

    public native void write(int var1, byte[] var2, int var3, int var4);

    public native void write(int var1, short[] var2, int var3, int var4);

    public native void write(int var1, char[] var2, int var3, int var4);

    public native void write(int var1, int[] var2, int var3, int var4);

    public native void write(int var1, long[] var2, int var3, int var4);

    public native void write(int var1, float[] var2, int var3, int var4);

    public native void write(int var1, double[] var2, int var3, int var4);

    public native byte getByte(int var1);

    public native char getChar(int var1);

    public native short getShort(int var1);

    public native int getInt(int var1);

    public native long getLong(int var1);

    public NativeLong getNativeLong(int offset) {
        return new NativeLong(SIZE == 8 ? this.getLong(offset) : (long)this.getInt(offset));
    }

    public native float getFloat(int var1);

    public native double getDouble(int var1);

    public native Pointer getPointer(int var1);

    public ByteBuffer getByteBuffer(int offset, int length) {
        return this.getDirectByteBuffer(offset, length).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer getDirectByteBuffer(int var1, int var2);

    public native String getString(int var1, boolean var2);

    public String getString(int offset) {
        int len;
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null && (len = this.indexOf(offset, (byte)0)) != -1) {
            byte[] data = this.getByteArray(offset, len);
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.getString(offset, false);
    }

    public byte[] getByteArray(int offset, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(int offset, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(int offset, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(int offset, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(int offset, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(int offset, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(int offset, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(int offset, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.getPointer(offset + i * SIZE);
        }
        return buf;
    }

    public native void setByte(int var1, byte var2);

    public native void setShort(int var1, short var2);

    public native void setChar(int var1, char var2);

    public native void setInt(int var1, int var2);

    public native void setLong(int var1, long var2);

    public void setNativeLong(int offset, NativeLong value) {
        if (SIZE == 8) {
            this.setLong(offset, value.longValue());
        } else {
            this.setInt(offset, value.intValue());
        }
    }

    public native void setFloat(int var1, float var2);

    public native void setDouble(int var1, double var2);

    public native void setPointer(int var1, Pointer var2);

    public native void setString(int var1, String var2, boolean var3);

    public void setString(int offset, String value) {
        byte[] data = Native.getBytes(value);
        this.write(offset, data, 0, data.length);
        this.setByte(offset + data.length, (byte)0);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    static {
        NULL = null;
        PM1 = new Pointer(-1L);
        if (!Pointer.loadNativeLibrary()) {
            System.loadLibrary("jnidispatch");
        }
        SIZE = Pointer.initIDs();
        LONG_SIZE = Pointer.longSize();
        WCHAR_SIZE = Pointer.wideCharSize();
    }
}

