/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import com.sun.jna.TypeMapper;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class Native {
    private static Map typeMappers = Collections.synchronizedMap(new WeakHashMap());
    private static Map alignments = Collections.synchronizedMap(new WeakHashMap());

    private Native() {
    }

    public static long getWindowID(Window w) {
        if (!w.isDisplayable()) {
            throw new IllegalStateException("Window is not yet displayable");
        }
        if (System.getProperty("java.version").matches("^1\\.4\\..*") && !w.isVisible()) {
            throw new IllegalStateException("Window is not yet visible");
        }
        return Native.getWindowHandle0(w);
    }

    public static Pointer getWindowPointer(Window w) {
        if (!w.isDisplayable()) {
            throw new IllegalStateException("Window is not yet displayable");
        }
        return new Pointer(Native.getWindowHandle0(w));
    }

    private static native long getWindowHandle0(Window var0);

    public static native Pointer getByteBufferPointer(ByteBuffer var0);

    public static String toString(byte[] buf) {
        String s;
        int term;
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null) {
            try {
                return new String(buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if ((term = (s = new String(buf)).indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Library loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Library loadLibrary(String name, Class interfaceClass, Map options) {
        if (!Library.class.isAssignableFrom(interfaceClass)) {
            throw new IllegalArgumentException("Not a valid native library interface: " + interfaceClass);
        }
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        if (options.containsKey("type-mapper")) {
            typeMappers.put(interfaceClass, options.get("type-mapper"));
        }
        if (options.containsKey("structure-alignment")) {
            alignments.put(interfaceClass, options.get("structure-alignment"));
        }
        return proxy;
    }

    private static boolean loadInstance(Class cls) {
        if (cls != null) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || (field.getModifiers() & 8) == 0) continue;
                    field.get(null);
                    return true;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
            }
        }
        return false;
    }

    public static TypeMapper getTypeMapper(Class interfaceClass) {
        if (!Native.loadInstance(interfaceClass) || !typeMappers.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("TYPE_MAPPER");
                return (TypeMapper)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("TYPE_MAPPER must be a public TypeMapper field (" + e + "): " + interfaceClass);
            }
        }
        return (TypeMapper)typeMappers.get(interfaceClass);
    }

    public static int getStructureAlignment(Class interfaceClass) {
        Integer value;
        if (!Native.loadInstance(interfaceClass) || !alignments.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                return (Integer)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public int field (" + e + "): " + interfaceClass);
            }
        }
        return (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
    }

    static byte[] getBytes(String s) {
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }
}

