/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.sun.jmx.trace.Trace;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerAlarmClock;
import javax.management.timer.TimerAlarmClockNotification;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private static final String dbgTag = "Timer";
    private Hashtable timerTable = new Hashtable();
    private boolean sendPastNotifications = false;
    private transient boolean isActive = false;
    private transient long sequenceNumber = 0L;
    private static final int TIMER_NOTIF_INDEX = 0;
    private static final int TIMER_DATE_INDEX = 1;
    private static final int TIMER_PERIOD_INDEX = 2;
    private static final int TIMER_NB_OCCUR_INDEX = 3;
    private static final int ALARM_CLOCK_INDEX = 4;
    private static final int FIXED_RATE_INDEX = 5;
    private int counterID = 0;
    private java.util.Timer timer;

    boolean isTraceOn() {
        return Trace.isSelected(1, 8);
    }

    void trace(String clz, String func, String info) {
        Trace.send(1, 8, clz, func, info);
    }

    void trace(String func, String info) {
        this.trace(dbgTag, func, info);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 8);
    }

    void debug(String clz, String func, String info) {
        Trace.send(2, 8, clz, func, info);
    }

    void debug(String func, String info) {
        this.debug(dbgTag, func, info);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the timer");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "starting the timer");
        }
        if (!this.isActive) {
            this.timer = new java.util.Timer();
            Date currentDate = new Date();
            this.sendPastNotifications(currentDate, this.sendPastNotifications);
            Enumeration e = this.timerTable.elements();
            while (e.hasMoreElements()) {
                TimerAlarmClock alarmClock;
                Object[] obj = (Object[])e.nextElement();
                Date date = (Date)obj[1];
                boolean fixedRate = (Boolean)obj[5];
                if (fixedRate) {
                    alarmClock = new TimerAlarmClock(this, date);
                    obj[4] = alarmClock;
                    this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
                    continue;
                }
                alarmClock = new TimerAlarmClock(this, date.getTime() - currentDate.getTime());
                obj[4] = alarmClock;
                this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
            }
            this.isActive = true;
            if (this.isTraceOn()) {
                this.trace("start", "timer started");
            }
        } else if (this.isTraceOn()) {
            this.trace("start", "the timer is already activated");
        }
    }

    public synchronized void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stoping the timer");
        }
        if (this.isActive) {
            Enumeration e = this.timerTable.elements();
            while (e.hasMoreElements()) {
                Object[] obj = (Object[])e.nextElement();
                TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
                if (alarmClock == null) continue;
                alarmClock.cancel();
                alarmClock = null;
            }
            this.timer.cancel();
            this.isActive = false;
            if (this.isTraceOn()) {
                this.trace("stop", "timer stopped");
            }
        } else if (this.isTraceOn()) {
            this.trace("stop", "the timer is already deactivated");
        }
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Timer notification date cannot be null.");
        }
        if (period < 0L || nbOccurences < 0L) {
            throw new IllegalArgumentException("Negative values for the periodicity");
        }
        Date currentDate = new Date();
        if (currentDate.after(date)) {
            date.setTime(currentDate.getTime());
            if (this.isTraceOn()) {
                this.trace("addNotification", "update timer notification to add with:\n\tNotification date = " + date);
            }
        }
        Integer notifID = null;
        notifID = new Integer(++this.counterID);
        TimerNotification notif = new TimerNotification(type, this, 0L, 0L, message, notifID);
        notif.setUserData(userData);
        Object[] obj = new Object[6];
        TimerAlarmClock alarmClock = fixedRate ? new TimerAlarmClock(this, date) : new TimerAlarmClock(this, date.getTime() - currentDate.getTime());
        Date d = new Date(date.getTime());
        obj[0] = notif;
        obj[1] = d;
        obj[2] = new Long(period);
        obj[3] = new Long(nbOccurences);
        obj[4] = alarmClock;
        obj[5] = new Boolean(fixedRate);
        if (this.isTraceOn()) {
            this.trace("addNotification", "adding timer notification:\n\tNotification source = " + notif.getSource() + "\n\tNotification type = " + notif.getType() + "\n\tNotification ID = " + notifID + "\n\tNotification date = " + d + "\n\tNotification period = " + period + "\n\tNotification nb of occurences = " + nbOccurences + "\n\tNotification executes at fixed rate = " + fixedRate);
        }
        this.timerTable.put(notifID, obj);
        if (this.isActive) {
            if (fixedRate) {
                this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
            } else {
                this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
            }
        }
        if (this.isTraceOn()) {
            this.trace("addNotification", "timer notification added");
        }
        return notifID;
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, nbOccurences, false);
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L);
    }

    public synchronized void removeNotification(Integer id) throws InstanceNotFoundException {
        if (!this.timerTable.containsKey(id)) {
            throw new InstanceNotFoundException("Timer notification to remove not in the list of notifications");
        }
        Object[] obj = (Object[])this.timerTable.get(id);
        TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
        if (alarmClock != null) {
            alarmClock.cancel();
            alarmClock = null;
        }
        if (this.isTraceOn()) {
            this.trace("removeNotification", "removing timer notification:\n\tNotification source = " + ((TimerNotification)obj[0]).getSource() + "\n\tNotification type = " + ((TimerNotification)obj[0]).getType() + "\n\tNotification ID = " + ((TimerNotification)obj[0]).getNotificationID() + "\n\tNotification date = " + obj[1] + "\n\tNotification period = " + obj[2] + "\n\tNotification nb of occurences = " + obj[3] + "\n\tNotification executes at fixed rate = " + obj[5]);
        }
        this.timerTable.remove(id);
        if (this.isTraceOn()) {
            this.trace("removeNotification", "timer notification removed");
        }
    }

    public synchronized void removeNotifications(String type) throws InstanceNotFoundException {
        Vector v = this.getNotificationIDs(type);
        if (v.isEmpty()) {
            throw new InstanceNotFoundException("Timer notifications to remove not in the list of notifications");
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            TimerNotification notif = (TimerNotification)e.nextElement();
            Integer id = notif.getNotificationID();
            Object[] obj = (Object[])this.timerTable.get(id);
            this.timerTable.remove(id);
            TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
            if (alarmClock == null) continue;
            alarmClock.cancel();
        }
    }

    public synchronized void removeAllNotifications() {
        Enumeration e = this.timerTable.elements();
        while (e.hasMoreElements()) {
            Object[] obj = (Object[])e.nextElement();
            TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
            alarmClock.cancel();
            alarmClock = null;
        }
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "removing all timer notifications");
        }
        this.timerTable.clear();
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "all timer notifications removed");
        }
        this.counterID = 0;
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "timer notification counter ID resetted");
        }
    }

    public int getNbNotifications() {
        return this.timerTable.size();
    }

    public synchronized Vector getAllNotificationIDs() {
        Vector<Integer> v = new Vector<Integer>();
        Enumeration e = this.timerTable.keys();
        while (e.hasMoreElements()) {
            v.addElement((Integer)e.nextElement());
        }
        return v;
    }

    public synchronized Vector getNotificationIDs(String type) {
        Vector<TimerNotification> v = new Vector<TimerNotification>();
        Enumeration e = this.timerTable.elements();
        if (type == null) {
            while (e.hasMoreElements()) {
                Object[] obj = (Object[])e.nextElement();
                String s = ((TimerNotification)obj[0]).getType();
                if (s != null) continue;
                v.addElement((TimerNotification)obj[0]);
            }
        } else {
            while (e.hasMoreElements()) {
                Object[] obj = (Object[])e.nextElement();
                String s = ((TimerNotification)obj[0]).getType();
                if (!type.equals(s)) continue;
                v.addElement((TimerNotification)obj[0]);
            }
        }
        return v;
    }

    public String getNotificationType(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getType();
        }
        return null;
    }

    public String getNotificationMessage(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getMessage();
        }
        return null;
    }

    public Object getNotificationUserData(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getUserData();
        }
        return null;
    }

    public Date getDate(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            Date date = (Date)obj[1];
            return new Date(date.getTime());
        }
        return null;
    }

    public Long getPeriod(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            Long period = (Long)obj[2];
            return new Long(period);
        }
        return null;
    }

    public Long getNbOccurences(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            Long nbOccurences = (Long)obj[3];
            return new Long(nbOccurences);
        }
        return null;
    }

    public Boolean getFixedRate(Integer id) {
        Object[] obj = (Object[])this.timerTable.get(id);
        if (obj != null) {
            Boolean fixedRate = (Boolean)obj[5];
            return new Boolean(fixedRate);
        }
        return null;
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public void setSendPastNotifications(boolean value) {
        this.sendPastNotifications = value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isEmpty() {
        return this.timerTable.isEmpty();
    }

    private synchronized void sendPastNotifications(Date currentDate, boolean currentFlag) {
        Enumeration e = this.timerTable.elements();
        while (e.hasMoreElements()) {
            Object[] obj = (Object[])e.nextElement();
            TimerNotification notif = (TimerNotification)obj[0];
            Integer notifID = notif.getNotificationID();
            Date date = (Date)obj[1];
            while (currentDate.after(date) && this.timerTable.containsKey(notifID)) {
                if (currentFlag) {
                    if (this.isTraceOn()) {
                        this.trace("sendPastNotifications", "sending past timer notification:\n\tNotification source = " + notif.getSource() + "\n\tNotification type = " + notif.getType() + "\n\tNotification ID = " + notif.getNotificationID() + "\n\tNotification date = " + date + "\n\tNotification period = " + obj[2] + "\n\tNotification nb of occurences = " + obj[3] + "\n\tNotification executes at fixed rate = " + obj[5]);
                    }
                    this.sendNotification(date, notif);
                    if (this.isTraceOn()) {
                        this.trace("sendPastNotifications", "past timer notification sent");
                    }
                }
                this.updateTimerTable(notif.getNotificationID());
            }
        }
    }

    private synchronized void updateTimerTable(Integer notifID) {
        Object[] obj = (Object[])this.timerTable.get(notifID);
        Date date = (Date)obj[1];
        Long period = (Long)obj[2];
        Long nbOccurences = (Long)obj[3];
        Boolean fixedRate = (Boolean)obj[5];
        TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
        if (period != 0L) {
            if (nbOccurences == 0L || nbOccurences > 1L) {
                date.setTime(date.getTime() + period);
                obj[3] = new Long(Math.max(0L, nbOccurences - 1L));
                nbOccurences = (Long)obj[3];
                if (this.isActive) {
                    if (fixedRate.booleanValue()) {
                        alarmClock = new TimerAlarmClock(this, date);
                        obj[4] = alarmClock;
                        this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
                    } else {
                        alarmClock = new TimerAlarmClock(this, period);
                        obj[4] = alarmClock;
                        this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
                    }
                }
                if (this.isTraceOn()) {
                    TimerNotification notif = (TimerNotification)obj[0];
                    this.trace("updateTimerTable", "update timer notification with:\n\tNotification source = " + notif.getSource() + "\n\tNotification type = " + notif.getType() + "\n\tNotification ID = " + notifID + "\n\tNotification date = " + date + "\n\tNotification period = " + period + "\n\tNotification nb of occurences = " + nbOccurences + "\n\tNotification executes at fixed rate = " + fixedRate);
                }
            } else {
                if (alarmClock != null) {
                    alarmClock.cancel();
                    alarmClock = null;
                }
                this.timerTable.remove(notifID);
            }
        } else {
            if (alarmClock != null) {
                alarmClock.cancel();
                alarmClock = null;
            }
            this.timerTable.remove(notifID);
        }
    }

    void notifyAlarmClock(TimerAlarmClockNotification notification) {
        TimerNotification timerNotification = null;
        Date timerDate = null;
        TimerAlarmClock alarmClock = (TimerAlarmClock)notification.getSource();
        Enumeration e = this.timerTable.elements();
        while (e.hasMoreElements()) {
            Object[] obj = (Object[])e.nextElement();
            if (obj[4] != alarmClock) continue;
            timerNotification = (TimerNotification)obj[0];
            timerDate = (Date)obj[1];
            break;
        }
        this.sendNotification(timerDate, timerNotification);
        this.updateTimerTable(timerNotification.getNotificationID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Date timeStamp, TimerNotification notification) {
        long curSeqNumber;
        if (this.isTraceOn()) {
            this.trace("sendNotification", "sending timer notification:\n\tNotification source = " + notification.getSource() + "\n\tNotification type = " + notification.getType() + "\n\tNotification ID = " + notification.getNotificationID() + "\n\tNotification date = " + timeStamp);
        }
        Object object = this;
        synchronized (object) {
            ++this.sequenceNumber;
            curSeqNumber = this.sequenceNumber;
        }
        object = notification;
        synchronized (object) {
            notification.setTimeStamp(timeStamp.getTime());
            notification.setSequenceNumber(curSeqNumber);
            this.sendNotification((TimerNotification)notification.cloneTimerNotification());
        }
        if (this.isTraceOn()) {
            this.trace("sendNotification", "timer notification sent");
        }
    }
}

