/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements TabularData,
Map,
Cloneable,
Serializable {
    static final long serialVersionUID = 5720150593236309827L;
    private Map dataMap;
    private TabularType tabularType;
    private transient String[] indexNamesArray;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int initialCapacity, float loadFactor) {
        if (tabularType == null) {
            throw new IllegalArgumentException("Argument tabularType cannot be null.");
        }
        this.tabularType = tabularType;
        List tmpNames = tabularType.getIndexNames();
        this.indexNamesArray = tmpNames.toArray(new String[tmpNames.size()]);
        this.dataMap = new HashMap(initialCapacity, loadFactor);
    }

    public TabularType getTabularType() {
        return this.tabularType;
    }

    public Object[] calculateIndex(CompositeData value) {
        this.checkValueType(value);
        return this.internalCalculateIndex(value).toArray();
    }

    public boolean containsKey(Object key) {
        Object[] k;
        try {
            k = (Object[])key;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.containsKey(k);
    }

    public boolean containsKey(Object[] key) {
        return key == null ? false : this.dataMap.containsKey(Arrays.asList(key));
    }

    public boolean containsValue(CompositeData value) {
        return this.dataMap.containsValue(value);
    }

    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.get((Object[])key);
    }

    public CompositeData get(Object[] key) {
        this.checkKeyType(key);
        return (CompositeData)this.dataMap.get(Arrays.asList(key));
    }

    public Object put(Object key, Object value) {
        this.put((CompositeData)value);
        return value;
    }

    public void put(CompositeData value) {
        List index = this.checkValueAndIndex(value);
        this.dataMap.put(index, value);
    }

    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    public CompositeData remove(Object[] key) {
        this.checkKeyType(key);
        return (CompositeData)this.dataMap.remove(Arrays.asList(key));
    }

    public void putAll(Map t) {
        CompositeData[] values;
        if (t == null || t.size() == 0) {
            return;
        }
        try {
            values = t.values().toArray(new CompositeData[t.size()]);
        }
        catch (ArrayStoreException e) {
            throw new ClassCastException("Map argument t contains values which are not instances of <tt>CompositeData</tt>");
        }
        this.putAll(values);
    }

    public void putAll(CompositeData[] values) {
        int i;
        if (values == null || values.length == 0) {
            return;
        }
        ArrayList<List> indexes = new ArrayList<List>(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            List index = this.checkValueAndIndex(values[i]);
            if (indexes.contains(index)) {
                throw new KeyAlreadyExistsException("Argument elements values[" + i + "] and values[" + indexes.indexOf(index) + "] have the same indexes, " + "calculated according to this TabularData instance's tabularType.");
            }
            indexes.add(index);
        }
        for (i = 0; i < values.length; ++i) {
            this.dataMap.put(indexes.get(i), values[i]);
        }
    }

    public void clear() {
        this.dataMap.clear();
    }

    public int size() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return this.dataMap.keySet();
    }

    public Collection values() {
        return this.dataMap.values();
    }

    public Set entrySet() {
        return this.dataMap.entrySet();
    }

    public Object clone() {
        try {
            TabularDataSupport c = (TabularDataSupport)super.clone();
            c.dataMap = (HashMap)((HashMap)c.dataMap).clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public boolean equals(Object obj) {
        TabularData other;
        if (obj == null) {
            return false;
        }
        try {
            other = (TabularData)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTabularType().equals(other.getTabularType())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            CompositeData value = (CompositeData)iter.next();
            if (other.containsValue(value)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        result += this.tabularType.hashCode();
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            result += ((Object)((CompositeData)iter.next())).hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "(tabularType=" + this.tabularType.toString() + ",contents=" + this.dataMap.toString() + ")";
    }

    private List internalCalculateIndex(CompositeData value) {
        return Collections.unmodifiableList(Arrays.asList(value.getAll(this.indexNamesArray)));
    }

    private void checkKeyType(Object[] key) {
        if (key == null || key.length == 0) {
            throw new NullPointerException("Argument key cannot be null or empty.");
        }
        if (key.length != this.indexNamesArray.length) {
            throw new InvalidKeyException("Argument key's length=" + key.length + " is different from the number of item values, which is " + this.indexNamesArray.length + ", specified for the indexing rows in this TabularData instance.");
        }
        for (int i = 0; i < key.length; ++i) {
            OpenType keyElementType = this.tabularType.getRowType().getType(this.indexNamesArray[i]);
            if (key[i] == null || keyElementType.isValue(key[i])) continue;
            throw new InvalidKeyException("Argument element key[" + i + "] is not a value for the open type expected for " + "this element of the index, whose name is \"" + this.indexNamesArray[i] + "\" and whose open type is " + keyElementType);
        }
    }

    private void checkValueType(CompositeData value) {
        if (value == null) {
            throw new NullPointerException("Argument value cannot be null.");
        }
        if (!value.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("Argument value's composite type [" + value.getCompositeType() + "] is not equal to " + "this TabularData instance's row type [" + this.tabularType.getRowType() + "].");
        }
    }

    private List checkValueAndIndex(CompositeData value) {
        this.checkValueType(value);
        List index = this.internalCalculateIndex(value);
        if (this.dataMap.containsKey(index)) {
            throw new KeyAlreadyExistsException("Argument value's index, calculated according to this TabularData instance's tabularType, already refers to a value in this table.");
        }
        return index;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        List tmpNames = this.tabularType.getIndexNames();
        this.indexNamesArray = tmpNames.toArray(new String[tmpNames.size()]);
    }
}

