/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class ArrayType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType elementType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.buildArrayClassName(dimension, elementType.getClassName()), ArrayType.buildArrayClassName(dimension, elementType.getClassName()), String.valueOf(dimension) + "-dimension array of " + elementType.getClassName());
        this.dimension = dimension;
        this.elementType = elementType;
    }

    private static String buildArrayClassName(int dimension, String elementClassName) throws OpenDataException {
        if (dimension < 1) {
            throw new IllegalArgumentException("Value of argument dimension must be greater than 0");
        }
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < dimension; ++i) {
            result.append('[');
        }
        result.append("[L");
        result.append(elementClassName);
        result.append(';');
        return result.toString();
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> objClass = obj.getClass();
        String objClassName = objClass.getName();
        if (!objClass.isArray()) {
            return false;
        }
        if (this.getClassName().equals(objClassName)) {
            return true;
        }
        if (this.elementType.getClassName().equals((class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = ArrayType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName()) || this.elementType.getClassName().equals((class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = ArrayType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName())) {
            Class<?> targetClass;
            try {
                targetClass = Class.forName(this.getClassName());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!targetClass.isAssignableFrom(objClass)) {
                return false;
            }
            return this.checkElementsType((Object[])obj, this.dimension);
        }
        return false;
    }

    private boolean checkElementsType(Object[] x_dim_Array, int dim) {
        if (dim > 1) {
            for (int i = 0; i < x_dim_Array.length; ++i) {
                if (this.checkElementsType((Object[])x_dim_Array[i], dim - 1)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < x_dim_Array.length; ++i) {
            if (x_dim_Array[i] == null || this.getElementOpenType().isValue(x_dim_Array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        ArrayType other;
        if (obj == null) {
            return false;
        }
        try {
            other = (ArrayType)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (other.dimension != this.dimension) {
            return false;
        }
        return this.elementType.equals(other.elementType);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.dimension;
            this.myHashCode = new Integer(value += this.elementType.hashCode());
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer result = new StringBuffer();
            result.append(this.getClass().getName());
            result.append("(name=");
            result.append(this.getTypeName());
            result.append(",dimension=");
            result.append(String.valueOf(this.dimension));
            result.append(",elementType=");
            result.append(this.elementType.toString());
            result.append(")");
            this.myToString = result.toString();
        }
        return this.myToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

