/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.trace.Trace;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class RequiredModelMBean
implements ModelMBean,
MBeanRegistration,
NotificationEmitter {
    ModelMBeanInfo modelMBeanInfo;
    private NotificationBroadcasterSupport generalBroadcaster = null;
    private NotificationBroadcasterSupport attributeBroadcaster = null;
    private Object managedResource = null;
    private String managedResourceType = "objectreference";
    private String currClass = "RequiredModelMBean";
    private boolean registered = false;
    private transient MBeanServer server = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        if (RequiredModelMBean.tracing()) {
            this.trace("RequiredModelMBean()", "Entry and Exit");
        }
        this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
    }

    public RequiredModelMBean(ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException {
        if (RequiredModelMBean.tracing()) {
            this.trace("RequiredModelMBean(MBeanInfo)", "Entry");
        }
        this.setModelMBeanInfo(mbi);
        if (RequiredModelMBean.tracing()) {
            this.trace("RequiredModelMBean(MBeanInfo)", "Exit");
        }
    }

    public void setModelMBeanInfo(ModelMBeanInfo mbi) throws MBeanException, RuntimeOperationsException {
        if (RequiredModelMBean.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Entry");
        }
        if (mbi == null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("setModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo is null: Raising exception.");
            }
            IllegalArgumentException x = new IllegalArgumentException("ModelMBeanInfo must not be null");
            String exceptionText = "Exception occured trying to initialize the ModelMBeanInfo of the RequiredModelMBean";
            throw new RuntimeOperationsException(x, "Exception occured trying to initialize the ModelMBeanInfo of the RequiredModelMBean");
        }
        if (this.registered) {
            if (RequiredModelMBean.tracing()) {
                this.trace("setModelMBeanInfo(ModelMBeanInfo)", "RequiredMBean is registered: Raising exception.");
            }
            String exceptionText = "Exception occured trying to set the ModelMBeanInfo of the RequiredModelMBean";
            IllegalStateException x = new IllegalStateException("cannot call setModelMBeanInfo while ModelMBean is registered");
            throw new RuntimeOperationsException(x, "Exception occured trying to set the ModelMBeanInfo of the RequiredModelMBean");
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Setting ModelMBeanInfo to " + this.printModelMBeanInfo(mbi));
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo notifications has " + mbi.getNotifications().length + " elements");
        }
        this.modelMBeanInfo = (ModelMBeanInfo)mbi.clone();
        if (RequiredModelMBean.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "set mbeanInfo to: " + this.printModelMBeanInfo(this.modelMBeanInfo));
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Exit");
        }
    }

    public void setManagedResource(Object mr, String mr_type) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (RequiredModelMBean.tracing()) {
            this.trace("setManagedResource(Object,String)", "Entry");
        }
        if (mr_type == null || !mr_type.equalsIgnoreCase("objectReference")) {
            if (RequiredModelMBean.tracing()) {
                this.trace("setManagedResource(Object,String)", "Managed Resouce Type is not supported: " + mr_type);
            }
            throw new InvalidTargetObjectTypeException(mr_type);
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("setManagedResource(Object,String)", "Managed Resouce is valid");
        }
        this.managedResource = mr;
        if (RequiredModelMBean.tracing()) {
            this.trace("setManagedResource(Object, String)", "Exit");
        }
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        ServiceNotFoundException x = new ServiceNotFoundException("Persistence not supported for this MBean");
        throw new MBeanException(x, x.getMessage());
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        ServiceNotFoundException x = new ServiceNotFoundException("Persistence not supported for this MBean");
        throw new MBeanException(x, x.getMessage());
    }

    private Object resolveForCacheValue(Descriptor descr) throws MBeanException, RuntimeOperationsException {
        Object objExpTime;
        String expTime;
        Descriptor mmbDescr;
        if (RequiredModelMBean.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "Entry");
        }
        Object response = null;
        boolean resetValue = false;
        boolean returnCachedValue = true;
        long currencyPeriod = 0L;
        if (descr == null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("resolveForCacheValue(Descriptor)", "Input Descriptor is null");
            }
            return response;
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "descriptor is " + descr.toString());
        }
        if ((mmbDescr = this.modelMBeanInfo.getMBeanDescriptor()) == null && RequiredModelMBean.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "MBean Descriptor is null");
        }
        if ((expTime = (objExpTime = descr.getFieldValue("currencyTimeLimit")) != null ? objExpTime.toString() : null) == null && mmbDescr != null) {
            objExpTime = mmbDescr.getFieldValue("currencyTimeLimit");
            expTime = objExpTime != null ? objExpTime.toString() : null;
        }
        if (expTime != null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("resolveForCacheValue(Descriptor)", "currencyTimeLimit: " + expTime);
            }
            if ((currencyPeriod = new Long(expTime) * 1000L) < 0L) {
                returnCachedValue = false;
                resetValue = true;
                if (RequiredModelMBean.tracing()) {
                    this.trace("resolveForCacheValue(Descriptor)", currencyPeriod + ": never Cached");
                }
            } else if (currencyPeriod == 0L) {
                returnCachedValue = true;
                resetValue = false;
                if (RequiredModelMBean.tracing()) {
                    this.trace("resolveForCacheValue(Descriptor)", "always valid Cache");
                }
            } else {
                long now;
                Object objtStamp = descr.getFieldValue("lastUpdatedTimeStamp");
                String tStamp = objtStamp != null ? objtStamp.toString() : null;
                if (RequiredModelMBean.tracing()) {
                    this.trace("resolveForCacheValue(Descriptor)", "lastUpdatedTimeStamp: " + tStamp);
                }
                if (tStamp == null) {
                    tStamp = "0";
                }
                long lastTime = new Long(tStamp);
                if (RequiredModelMBean.tracing()) {
                    this.trace("resolveForCacheValue(Descriptor)", " currencyPeriod:" + currencyPeriod + " lastUpdatedTimeStamp:" + lastTime);
                }
                if ((now = new Date().getTime()) < lastTime + currencyPeriod) {
                    returnCachedValue = true;
                    resetValue = false;
                    if (RequiredModelMBean.tracing()) {
                        this.trace("resolveForCacheValue(Descriptor)", " timed valid Cache for " + now + " < " + (lastTime + currencyPeriod));
                    }
                } else {
                    returnCachedValue = false;
                    resetValue = true;
                    if (RequiredModelMBean.tracing()) {
                        this.trace("resolveForCacheValue(Descriptor)", "timed expired cache for " + now + " > " + (lastTime + currencyPeriod));
                    }
                }
            }
            if (RequiredModelMBean.tracing()) {
                this.trace("resolveForCacheValue(Descriptor)", "returnCachedValue:" + returnCachedValue + " resetValue: " + resetValue);
            }
            if (returnCachedValue) {
                Object currValue = descr.getFieldValue("value");
                if (currValue != null) {
                    response = currValue;
                    if (RequiredModelMBean.tracing()) {
                        this.trace("resolveForCacheValue(Descriptor)", "valid Cache value: " + currValue);
                    }
                } else {
                    response = null;
                    if (RequiredModelMBean.tracing()) {
                        this.trace("resolveForCacheValue(Descriptor)", "no Cached value");
                    }
                }
            }
            if (resetValue) {
                descr.removeField("lastUpdatedTimeStamp");
                descr.removeField("value");
                response = null;
                this.modelMBeanInfo.setDescriptor(descr, null);
                if (RequiredModelMBean.tracing()) {
                    this.trace("resolveForCacheValue(Descriptor)", "reset cached value to null");
                }
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("resolveForCache(Descriptor)", "Exit");
        }
        return response;
    }

    public MBeanInfo getMBeanInfo() {
        if (RequiredModelMBean.tracing()) {
            this.trace("getMBeanInfo()", "Entry and Exit");
        }
        if (this.modelMBeanInfo == null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("getMBeanInfo()", "modelMBeanInfo is null");
            }
            this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("getMBeanInfo()", "ModelMBeanInfo is " + this.modelMBeanInfo.getClassName() + " for " + this.modelMBeanInfo.getDescription());
            this.trace("getMBeanInfo()", this.printModelMBeanInfo(this.modelMBeanInfo));
        }
        return (MBeanInfo)this.modelMBeanInfo.clone();
    }

    private String printModelMBeanInfo(ModelMBeanInfo info) {
        StringBuffer retStr = new StringBuffer();
        if (info == null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("printModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo to print is null, printing local ModelMBeanInfo");
            }
            info = this.modelMBeanInfo;
        }
        retStr.append("\nMBeanInfo for ModelMBean is:");
        retStr.append("\nCLASSNAME: \t" + info.getClassName());
        retStr.append("\nDESCRIPTION: \t" + info.getDescription());
        try {
            retStr.append("\nMBEAN DESCRIPTOR: \t" + info.getMBeanDescriptor());
        }
        catch (Exception e) {
            retStr.append("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        retStr.append("\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                ModelMBeanAttributeInfo attInfo = (ModelMBeanAttributeInfo)attrInfo[i];
                retStr.append(" ** NAME: \t" + attInfo.getName());
                retStr.append("    DESCR: \t" + attInfo.getDescription());
                retStr.append("    TYPE: \t" + attInfo.getType() + "    READ: \t" + attInfo.isReadable() + "    WRITE: \t" + attInfo.isWritable());
                retStr.append("    DESCRIPTOR: " + attInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No attributes **");
        }
        retStr.append("\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        if (constrInfo != null && constrInfo.length > 0) {
            for (int i = 0; i < constrInfo.length; ++i) {
                ModelMBeanConstructorInfo ctorInfo = (ModelMBeanConstructorInfo)constrInfo[i];
                retStr.append(" ** NAME: \t" + ctorInfo.getName());
                retStr.append("    DESCR: \t" + ctorInfo.getDescription());
                retStr.append("    PARAM: \t" + ctorInfo.getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ctorInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No Constructors **");
        }
        retStr.append("\nOPERATIONS");
        MBeanOperationInfo[] opsInfo = info.getOperations();
        if (opsInfo != null && opsInfo.length > 0) {
            for (int i = 0; i < opsInfo.length; ++i) {
                ModelMBeanOperationInfo operInfo = (ModelMBeanOperationInfo)opsInfo[i];
                retStr.append(" ** NAME: \t" + operInfo.getName());
                retStr.append("    DESCR: \t" + operInfo.getDescription());
                retStr.append("    PARAM: \t" + operInfo.getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + operInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No operations ** ");
        }
        retStr.append("\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo != null && notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                ModelMBeanNotificationInfo nInfo = (ModelMBeanNotificationInfo)notifInfo[i];
                retStr.append(" ** NAME: \t" + nInfo.getName());
                retStr.append("    DESCR: \t" + nInfo.getDescription());
                retStr.append("    DESCRIPTOR: " + nInfo.getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No notifications **");
        }
        retStr.append(" ** ModelMBean: End of MBeanInfo ** ");
        return retStr.toString();
    }

    private void echo(String txt) {
        this.trace("echo(txt)", txt);
    }

    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        if (RequiredModelMBean.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Entry");
        }
        if (opName == null) {
            IllegalArgumentException x = new IllegalArgumentException("Method name must not be null");
            throw new RuntimeOperationsException(x, "An exception occured while trying to invoke a method on a RequiredModelMBean");
        }
        ModelMBeanOperationInfo opInfo = null;
        Descriptor opDescr = null;
        Object response = null;
        Method mmbOpHandle = null;
        Class[] mmbSig = null;
        Object[] mmbArgs = opArgs;
        boolean[] mmbClassFlag = null;
        String opClassName = "";
        String opMethodName = opName;
        int opSplitter = opName.lastIndexOf(".");
        if (opSplitter > 0) {
            opClassName = opName.substring(0, opSplitter);
            opMethodName = opName.substring(opSplitter + 1);
        }
        if ((opSplitter = opMethodName.indexOf("(")) > 0) {
            opMethodName = opMethodName.substring(0, opSplitter);
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Finding operation " + opName + " as " + opMethodName);
        }
        boolean mmbLocalInvoke = true;
        if (opArgs != null && opArgs.length != 0) {
            mmbArgs = opArgs;
            mmbSig = new Class[opArgs.length];
            mmbClassFlag = new boolean[opArgs.length];
            for (int i = 0; i < opArgs.length; ++i) {
                try {
                    if (RequiredModelMBean.tracing()) {
                        this.trace("invoke(String, Object[], String[])", "finding class for " + sig[i]);
                    }
                    if (sig[i].equals(Boolean.TYPE.toString())) {
                        mmbSig[i] = Boolean.TYPE;
                    } else if (sig[i].equals(Integer.TYPE.toString())) {
                        mmbSig[i] = Integer.TYPE;
                    } else if (sig[i].equals(Character.TYPE.toString())) {
                        mmbSig[i] = Character.TYPE;
                    } else if (sig[i].equals(Float.TYPE.toString())) {
                        mmbSig[i] = Float.TYPE;
                    } else if (sig[i].equals(Long.TYPE.toString())) {
                        mmbSig[i] = Long.TYPE;
                    } else if (sig[i].equals(Double.TYPE.toString())) {
                        mmbSig[i] = Double.TYPE;
                    } else if (sig[i].equals(Byte.TYPE.toString())) {
                        mmbSig[i] = Byte.TYPE;
                    } else if (sig[i].equals(Short.TYPE.toString())) {
                        mmbSig[i] = Short.TYPE;
                    } else {
                        mmbClassFlag[i] = true;
                        mmbSig[i] = this.loadClass(sig[i]);
                    }
                    if (!RequiredModelMBean.tracing()) continue;
                    String mmbArgOut = mmbArgs[i] == null ? "null" : mmbArgs[i].toString();
                    this.trace("invoke(String, Object[], String[])", "invoke method found a valid argument: " + mmbSig[i].toString() + " is " + mmbArgOut);
                    continue;
                }
                catch (ClassNotFoundException cnfl) {
                    if (RequiredModelMBean.tracing()) {
                        this.trace("invoke(String, Object[], String[])", opName + " method " + opMethodName + "is not in RequiredModelMBean class:" + cnfl.getMessage());
                        this.trace("invoke(String, Object[], String[])", "The parameter class could not be found in default class loader");
                    }
                    mmbClassFlag[i] = true;
                    mmbSig[i] = null;
                    mmbLocalInvoke = false;
                }
            }
        } else {
            mmbSig = new Class[]{};
            mmbArgs = new Object[]{};
        }
        if (mmbLocalInvoke) {
            try {
                mmbOpHandle = this.getClass().getMethod(opMethodName, mmbSig);
            }
            catch (NoSuchMethodException nsml) {
                mmbLocalInvoke = false;
            }
        }
        if (mmbOpHandle != null || mmbLocalInvoke) {
            try {
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", opName + " being invoked on ModelMBean");
                }
                response = mmbOpHandle.invoke((Object)this, mmbArgs);
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "invoke returning " + (response == null ? "null" : "non-null") + " response from local invoke of " + opName);
                }
                return response;
            }
            catch (RuntimeErrorException ree) {
                throw new RuntimeOperationsException(ree, "RuntimeException occured in RequiredModelMBean while trying to invoke operation " + opName);
            }
            catch (RuntimeException re) {
                throw new RuntimeOperationsException(re, "RuntimeException occured in RequiredModelMBean while trying to invoke operation " + opName);
            }
            catch (IllegalAccessException iae) {
                throw new ReflectionException(iae, "IllegalAccessException occured in RequiredModelMBean while trying to invoke operation " + opName);
            }
            catch (InvocationTargetException ite) {
                Throwable mmbTargEx = ite.getTargetException();
                if (mmbTargEx instanceof RuntimeException) {
                    throw new MBeanException((RuntimeException)mmbTargEx, "RuntimeException thrown in RequiredModelMBean while trying to invoke operation " + opName);
                }
                if (mmbTargEx instanceof ReflectionException) {
                    throw (ReflectionException)mmbTargEx;
                }
                throw new MBeanException((Exception)mmbTargEx, "Exception thrown in RequiredModelMBean while trying to invoke operation " + opName);
            }
            catch (Error err) {
                throw new RuntimeErrorException(err, "Error occured in RequiredModelMBean while trying to invoke operation " + opName);
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Exception occured in RequiredModelMBean while trying to invoke operation " + opName);
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("invoke(String, Object[], String[])", opName + " is not on RequiredModelMBean, " + "looking in descriptor for " + opMethodName);
        }
        if ((opInfo = this.modelMBeanInfo.getOperation(opMethodName)) == null) {
            throw new MBeanException(new ServiceNotFoundException("operation " + opName + " execution not supported from mbeaninfo data"), "An exception occured in RequiredModelMBean while trying to invoke an operation");
        }
        opDescr = opInfo.getDescriptor();
        if (opDescr == null) {
            throw new MBeanException(new ServiceNotFoundException("operation " + opName + " execution not supported from descriptor data"), "An exception occured in RequiredModelMBean while trying to invoke an operation");
        }
        response = this.resolveForCacheValue(opDescr);
        if (response == null) {
            Method opHandle;
            Object currObj;
            if (RequiredModelMBean.tracing()) {
                this.trace("invoke(String, Object[], String[])", "No cached value returned for operation");
            }
            if ((currObj = opDescr.getFieldValue("targetObject")) != null) {
                String currType;
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "Found target object in descriptor");
                }
                if ((currType = (String)opDescr.getFieldValue("targetType")) == null || !currType.equalsIgnoreCase("objectReference")) {
                    throw new MBeanException(new InvalidTargetObjectTypeException(currType), "An exception occured while trying to invoke an operation on a descriptor provided target");
                }
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[]", "target object is a valid type");
                }
            } else if (this.managedResource != null) {
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "managedResource for invoke found");
                }
                currObj = this.managedResource;
            } else {
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "err managedResource for invoke is null");
                }
                throw new MBeanException(new ServiceNotFoundException("managedResource for invoke is null"), "An exception occured in RequiredModelMBean while trying to invoke an operation");
            }
            Class opClass = null;
            try {
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "getting class for operation");
                }
                opClass = opClassName == null || opClassName.equals("") ? ((opClassName = (String)opDescr.getFieldValue("class")) == null || opClassName.equals("") ? currObj.getClass() : this.loadClass(opClassName)) : this.loadClass(opClassName);
                if (opClass == null) {
                    throw new ReflectionException(new ClassNotFoundException("A valid class could not be found for " + opMethodName), "Exception occured while trying to find class for method of invoke");
                }
            }
            catch (ClassNotFoundException cnf) {
                throw new ReflectionException(cnf, "The target object class " + opClassName + " could not be found");
            }
            ClassLoader mmbLoader = null;
            try {
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "setting signature with correct class loaders for operation");
                }
                if ((mmbLoader = currObj.getClass().getClassLoader()) != null) {
                    for (int i = 0; i < mmbSig.length; ++i) {
                        if (!mmbClassFlag[i]) continue;
                        try {
                            mmbSig[i] = mmbLoader.loadClass(sig[i]);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            mmbSig[i] = this.loadClass(sig[i]);
                        }
                    }
                }
            }
            catch (ClassNotFoundException cnf) {
                throw new ReflectionException(cnf, "The parameter class could not be found");
            }
            if (RequiredModelMBean.tracing()) {
                this.trace("invoke(String, Object[], String[])", "Looking for operations class " + opClassName + " method " + opMethodName);
            }
            try {
                opHandle = opClass.getMethod(opMethodName, mmbSig);
                if (opHandle == null) {
                    throw new ReflectionException(new Exception("null method handle"), "Retrieved null method handle for method");
                }
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "Retrieved valid method handle for " + opClassName + "." + opMethodName);
                }
            }
            catch (NoSuchMethodException nsm) {
                throw new ReflectionException(nsm, "The method " + opClassName + "." + opMethodName + " could not be found");
            }
            try {
                response = opHandle.invoke(currObj, mmbArgs);
                if (RequiredModelMBean.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "invoke done for " + opName);
                }
                if (response != null && opDescr != null) {
                    Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
                    Object objctl = opDescr.getFieldValue("currencyTimeLimit");
                    String ctl = objctl != null ? objctl.toString() : null;
                    if (ctl == null && mmbDesc != null) {
                        objctl = mmbDesc.getFieldValue("currencyTimeLimit");
                        ctl = objctl != null ? objctl.toString() : null;
                    }
                    if (ctl != null && !ctl.equals("-1")) {
                        opDescr.setField("value", response);
                        opDescr.setField("lastUpdatedTimeStamp", new Long(new Date().getTime()).toString());
                        opInfo.setDescriptor(opDescr);
                        this.modelMBeanInfo.setDescriptor(opDescr, "operation");
                        if (RequiredModelMBean.tracing()) {
                            this.trace("invoke(String,Object[],Object[])", "new descriptor is " + opDescr.toString());
                            this.trace("invoke(String,Object[],Object[])", "OperationInfo descriptor is " + opInfo.getDescriptor().toString());
                            this.trace("invoke(String,Object[],Object[])", "OperationInfo descriptor is " + this.modelMBeanInfo.getDescriptor(opName, "operation").toString());
                        }
                    }
                    if (RequiredModelMBean.tracing()) {
                        this.trace("invoke(String, Object[], String[])", "invoke retrieved " + response.toString());
                    }
                }
            }
            catch (RuntimeErrorException ree) {
                throw new RuntimeOperationsException(ree, "RuntimeException occured in managed resource while trying to invoke operation " + opName);
            }
            catch (RuntimeException re) {
                throw new RuntimeOperationsException(re, "RuntimeException occured in managed resource while trying to invoke operation " + opName);
            }
            catch (IllegalAccessException iae) {
                throw new ReflectionException(iae, "IllegalAccessException occured in managed resource while trying to invoke operation " + opName);
            }
            catch (Error err) {
                throw new RuntimeErrorException(err, "Error occured in managed resource while trying to invoke operation " + opName);
            }
            catch (InvocationTargetException ite) {
                Throwable mmbTargEx = ite.getTargetException();
                if (mmbTargEx instanceof RuntimeException) {
                    throw new RuntimeMBeanException((RuntimeException)mmbTargEx, "RuntimeException thrown in managed resource while trying to invoke operation " + opName);
                }
                if (mmbTargEx instanceof Error) {
                    throw new RuntimeErrorException((Error)mmbTargEx, "Error thrown in managed resource while trying to invoke operation " + opName);
                }
                if (mmbTargEx instanceof ReflectionException) {
                    throw (ReflectionException)mmbTargEx;
                }
                throw new MBeanException((Exception)mmbTargEx, "Exception thrown in managed resource while trying to invoke operation " + opName);
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Exception occured in managed resource while trying to invoke operation " + opName);
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Exit");
        }
        return response;
    }

    public Object getAttribute(String attrName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object response;
        block33: {
            if (attrName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occured trying to get attribute of a RequiredModelMBean");
            }
            if (RequiredModelMBean.tracing()) {
                this.trace("getAttribute(String)", "Entry with" + attrName);
            }
            ModelMBeanAttributeInfo attrInfo = null;
            Descriptor attrDescr = null;
            response = null;
            try {
                if (this.modelMBeanInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanInfo not found for " + attrName);
                }
                attrInfo = this.modelMBeanInfo.getAttribute(attrName);
                Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
                if (attrInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanAttributeInfo not found for " + attrName);
                }
                attrDescr = attrInfo.getDescriptor();
                if (attrDescr != null) {
                    String responseClass;
                    if (!attrInfo.isReadable()) {
                        throw new AttributeNotFoundException("getAttribute failed: " + attrName + " is not readable ");
                    }
                    response = this.resolveForCacheValue(attrDescr);
                    if (RequiredModelMBean.tracing()) {
                        this.trace("getAttribute(String)", "*** cached value is " + response);
                    }
                    if (response == null) {
                        String attrGetMethod;
                        if (RequiredModelMBean.tracing()) {
                            this.trace("getAttribute(String)", "**** cached value is null - getting getMethod");
                        }
                        if ((attrGetMethod = (String)attrDescr.getFieldValue("getMethod")) != null) {
                            Object getResponse;
                            if (RequiredModelMBean.tracing()) {
                                this.trace("getAttribute(String)", "invoking a getMethod for " + attrName);
                            }
                            if ((getResponse = this.invoke(attrGetMethod, new Object[0], new String[0])) != null) {
                                if (RequiredModelMBean.tracing()) {
                                    this.trace("getAttribute(String)", "got a non-null response from getMethod\n");
                                }
                                response = getResponse;
                                Object objctl = attrDescr.getFieldValue("currencyTimeLimit");
                                String ctl = objctl != null ? objctl.toString() : null;
                                if (ctl == null && mmbDesc != null) {
                                    objctl = mmbDesc.getFieldValue("currencyTimeLimit");
                                    ctl = objctl != null ? objctl.toString() : null;
                                }
                                if (ctl != null && !ctl.equals("-1")) {
                                    if (RequiredModelMBean.tracing()) {
                                        this.trace("getAttribute(String)", "setting cached value and lastUpdatedTime in descriptor");
                                    }
                                    attrDescr.setField("value", response);
                                    String stamp = new Long(new Date().getTime()).toString();
                                    attrDescr.setField("lastUpdatedTimeStamp", stamp);
                                    attrInfo.setDescriptor(attrDescr);
                                    this.modelMBeanInfo.setDescriptor(attrDescr, "attribute");
                                    if (RequiredModelMBean.tracing()) {
                                        this.trace("getAttribute(String)", "new descriptor is " + attrDescr.toString());
                                        this.trace("getAttribute(String)", "local: AttributeInfo descriptor is " + attrInfo.getDescriptor().toString());
                                        String attStr = this.modelMBeanInfo.getDescriptor(attrName, "attribute").toString();
                                        this.trace("getAttribute(String)", "modelMBeanInfo: AttributeInfo descriptor is " + attStr);
                                    }
                                }
                            } else {
                                if (RequiredModelMBean.tracing()) {
                                    this.trace("getAttribute(String)", "got a null response from getMethod\n");
                                }
                                response = null;
                            }
                        } else {
                            String qualifier = "";
                            response = attrDescr.getFieldValue("value");
                            if (response == null) {
                                qualifier = "default ";
                                response = attrDescr.getFieldValue("default");
                            }
                            if (RequiredModelMBean.tracing()) {
                                this.trace("getAttribute(String)", "could not find getMethod for " + attrName + ", returning descriptor " + qualifier + "value");
                            }
                        }
                    }
                    String respType = attrInfo.getType();
                    if (response != null && !respType.equals(responseClass = response.getClass().getName())) {
                        String[] primitiveTypes = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Character.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Void.TYPE.getName()};
                        String[] primitiveWrappers = new String[]{(class$java$lang$Boolean == null ? (class$java$lang$Boolean = RequiredModelMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = RequiredModelMBean.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$lang$Character == null ? (class$java$lang$Character = RequiredModelMBean.class$("java.lang.Character")) : class$java$lang$Character).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = RequiredModelMBean.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = RequiredModelMBean.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = RequiredModelMBean.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = RequiredModelMBean.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = RequiredModelMBean.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Void == null ? (class$java$lang$Void = RequiredModelMBean.class$("java.lang.Void")) : class$java$lang$Void).getName()};
                        boolean correspondingTypes = false;
                        for (int i = 0; i <= 8; ++i) {
                            if (!respType.equals(primitiveTypes[i]) || !responseClass.equals(primitiveWrappers[i])) continue;
                            correspondingTypes = true;
                            break;
                        }
                        if (!correspondingTypes) {
                            if (RequiredModelMBean.tracing()) {
                                this.trace("getAttribute(String)", "wrong response type '" + respType + "'");
                            }
                            throw new MBeanException(new InvalidAttributeValueException("Wrong value type received for get attribute"), "An exception occured while trying to get an attribute value through a RequiredModelMBean");
                        }
                    }
                    break block33;
                }
                if (RequiredModelMBean.tracing()) {
                    this.trace("getAttribute(String)", "getMethod failed " + attrName + " not in attributeDescriptor\n");
                }
                throw new MBeanException(new InvalidAttributeValueException("Unable to resolve attribute value, no getMethod defined in descriptor for attribute"), "An exception occured while trying to get an attribute value through a RequiredModelMBean");
            }
            catch (MBeanException mbe) {
                throw mbe;
            }
            catch (AttributeNotFoundException t) {
                throw t;
            }
            catch (Exception e) {
                if (RequiredModelMBean.tracing()) {
                    this.trace("getAttribute(String)", "getMethod failed with " + e.getMessage() + " exception type " + e.getClass().toString());
                }
                throw new MBeanException(e, "An exception occured while trying to get an attribute value: " + e.getMessage());
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("getAttribute(String)", "Exit");
        }
        return response;
    }

    public AttributeList getAttributes(String[] attrNames) {
        if (RequiredModelMBean.tracing()) {
            this.trace("getAttributes(String[])", "Entry");
        }
        AttributeList responseList = null;
        if (attrNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames must not be null"), "Exception occured trying to get attributes of a RequiredModelMBean");
        }
        responseList = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            try {
                responseList.add(new Attribute(attrNames[i], this.getAttribute(attrNames[i])));
                continue;
            }
            catch (Exception e) {
                this.error("getAttributes(String[])", "Failed to get \"" + attrNames[i] + "\": " + e);
                this.traceX("getAttributes(String[])", e);
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("getAttributes(String[])", "Exit");
        }
        return responseList;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Attribute oldAttr;
        if (RequiredModelMBean.tracing()) {
            this.trace("setAttribute()", "Entry");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute must not be null"), "Exception occured trying to set an attribute of a RequiredModelMBean");
        }
        String attrName = attribute.getName();
        Object attrValue = attribute.getValue();
        boolean updateDescriptor = false;
        ModelMBeanAttributeInfo attrInfo = this.modelMBeanInfo.getAttribute(attrName);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("setAttribute failed: " + attrName + " is not found ");
        }
        Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
        Descriptor attrDescr = attrInfo.getDescriptor();
        if (attrDescr != null) {
            boolean updateCache;
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("setAttribute failed: " + attrName + " is not writable ");
            }
            Object setResponse = null;
            String attrSetMethod = (String)attrDescr.getFieldValue("setMethod");
            String attrType = attrInfo.getType();
            Object currValue = "Unknown";
            try {
                currValue = this.getAttribute(attrName);
            }
            catch (Throwable t) {
                // empty catch block
            }
            oldAttr = new Attribute(attrName, currValue);
            if (attrSetMethod == null) {
                if (attrValue != null) {
                    try {
                        Class clazz = this.loadClass(attrType);
                        if (!clazz.isInstance(attrValue)) {
                            throw new InvalidAttributeValueException(clazz.getName() + " expected, " + attrValue.getClass().getName() + " received.");
                        }
                    }
                    catch (ClassNotFoundException x) {
                        this.error("setAttribute", "Class " + attrType + " for attribute " + attrName + " not found: " + x);
                        this.debug("setAttribute", x);
                    }
                }
                updateDescriptor = true;
            } else {
                setResponse = this.invoke(attrSetMethod, new Object[]{attrValue}, new String[]{attrType});
            }
            Object objctl = attrDescr.getFieldValue("currencyTimeLimit");
            String ctl = objctl != null ? objctl.toString() : null;
            if (ctl == null && mmbDesc != null) {
                objctl = mmbDesc.getFieldValue("currencyTimeLimit");
                ctl = objctl != null ? objctl.toString() : null;
            }
            boolean bl = updateCache = ctl != null && !ctl.equals("-1");
            if (updateCache || updateDescriptor) {
                if (RequiredModelMBean.tracing()) {
                    this.trace("setAttribute()", "setting cached value of " + attrName + " to " + attrValue);
                }
                attrDescr.setField("value", attrValue);
                if (updateCache) {
                    String currtime = new Long(new Date().getTime()).toString();
                    attrDescr.setField("lastUpdatedTimeStamp", currtime);
                }
                attrInfo.setDescriptor(attrDescr);
                this.modelMBeanInfo.setDescriptor(attrDescr, "attribute");
                if (RequiredModelMBean.tracing()) {
                    this.trace("setAttribute()", "new descriptor is " + attrDescr.toString());
                    this.trace("setAttribute()", "AttributeInfo descriptor is " + attrInfo.getDescriptor().toString());
                    this.trace("setAttribute()", "AttributeInfo descriptor is " + this.modelMBeanInfo.getDescriptor(attrName, "attribute").toString());
                }
            }
            if (RequiredModelMBean.tracing()) {
                this.trace("setAttribute()", "sending sendAttributeNotification");
            }
        } else {
            if (RequiredModelMBean.tracing()) {
                this.trace("setAttribute(String)", "setMethod failed " + attrName + " not in attributeDescriptor\n");
            }
            throw new InvalidAttributeValueException("Unable to resolve attribute value, no defined in descriptor for attribute");
        }
        this.sendAttributeChangeNotification(oldAttr, attribute);
        if (RequiredModelMBean.tracing()) {
            this.trace("setAttribute(Attribute)", "Exit");
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (RequiredModelMBean.tracing()) {
            this.trace("setAttributes(AttributeList)", "Entry");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes must not be null"), "Exception occured trying to set attributes of a RequiredModelMBean");
        }
        AttributeList responseList = new AttributeList();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            try {
                this.setAttribute(attr);
                responseList.add(attr);
            }
            catch (Exception excep) {
                responseList.remove(attr);
            }
        }
        return responseList;
    }

    private ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    private synchronized void writeToLog(String logFileName, String logEntry) throws Exception {
        PrintStream logOut = null;
        FileOutputStream fos = null;
        if (RequiredModelMBean.tracing()) {
            this.trace("writeToLog()", "Notification Logging to " + logFileName + ": " + logEntry);
        }
        if (logFileName == null || logEntry == null) {
            if (RequiredModelMBean.tracing()) {
                this.trace("writeToLog()", "Bad input parameters");
            }
            return;
        }
        try {
            fos = new FileOutputStream(logFileName, true);
            logOut = new PrintStream(fos);
            logOut.println(logEntry);
            logOut.close();
            if (RequiredModelMBean.tracing()) {
                this.trace("writeToLog()", "Successfully opened log " + logFileName);
            }
        }
        catch (Exception e) {
            if (RequiredModelMBean.tracing()) {
                this.trace("writeToLog", "Exception " + e.toString() + " trying to write to the Notification log file " + logFileName);
            }
            throw e;
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        String ftag = "addNotificationListener(NotificationListener, NotificationFilter, Object)";
        if (RequiredModelMBean.tracing()) {
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "Entry");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notification listener must not be null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new NotificationBroadcasterSupport();
        }
        this.generalBroadcaster.addNotificationListener(listener, filter, handback);
        if (RequiredModelMBean.tracing()) {
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "NotificationListener added");
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "Exit");
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String ftag = "removeNotificationListener(NotificationListener)";
        if (RequiredModelMBean.tracing()) {
            this.trace("removeNotificationListener(NotificationListener)", "Entry");
        }
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(listener);
        if (RequiredModelMBean.tracing()) {
            this.trace("removeNotificationListener(NotificationListener)", "Exit");
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String ftag = "removeNotificationListener(NotificationListener, NotificationFilter, Object)";
        if (RequiredModelMBean.tracing()) {
            this.trace("removeNotificationListener(NotificationListener, NotificationFilter, Object)", "Entry");
        }
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(listener, filter, handback);
        if (RequiredModelMBean.tracing()) {
            this.trace("removeNotificationListener(NotificationListener, NotificationFilter, Object)", "Exit");
        }
    }

    public void sendNotification(Notification ntfyObj) throws MBeanException, RuntimeOperationsException {
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(Notification)", "Entry");
        }
        if (ntfyObj == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification object must not be null"), "Exception occured trying to send a notification from a RequiredModelMBean");
        }
        Descriptor ntfyDesc = this.modelMBeanInfo.getDescriptor(ntfyObj.getType(), "notification");
        Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
        if (ntfyDesc != null) {
            String logging = (String)ntfyDesc.getFieldValue("log");
            if (logging == null && mmbDesc != null) {
                logging = (String)mmbDesc.getFieldValue("log");
            }
            if (logging != null && (logging.equalsIgnoreCase("t") || logging.equalsIgnoreCase("true"))) {
                String logfile = (String)ntfyDesc.getFieldValue("logfile");
                if (logfile == null && mmbDesc != null) {
                    logfile = (String)mmbDesc.getFieldValue("logfile");
                }
                if (logfile != null) {
                    try {
                        this.writeToLog(logfile, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Severity = " + (String)ntfyDesc.getFieldValue("severity"));
                    }
                    catch (Exception e) {
                        this.error("sendNotification(Notification)", "Failed to log " + ntfyObj.getType() + " notification: " + e);
                        this.traceX("sendNotification(Notification)", e);
                    }
                }
            }
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.sendNotification(ntfyObj);
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(Notification)", "sendNotification sent provided notification object");
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(Notification)", "Exit");
        }
    }

    public void sendNotification(String ntfyText) throws MBeanException, RuntimeOperationsException {
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(String)", "Entry");
        }
        if (ntfyText == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification message must not be null"), "Exception occured trying to send a text notification from a ModelMBean");
        }
        Notification myNtfyObj = new Notification("jmx.modelmbean.generic", (Object)this, 1L, ntfyText);
        this.sendNotification(myNtfyObj);
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(string)", "Notification sent");
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendNotification(String)", "Exit");
        }
    }

    private static final boolean hasNotification(ModelMBeanInfo info, String notifName) {
        try {
            if (info == null) {
                return false;
            }
            return info.getNotification(notifName) != null;
        }
        catch (MBeanException x) {
            return false;
        }
        catch (RuntimeOperationsException r) {
            return false;
        }
    }

    private static final ModelMBeanNotificationInfo makeGenericInfo() {
        DescriptorSupport genericDescriptor = new DescriptorSupport(new String[]{"name=GENERIC", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.modelmbean.generic"});
        return new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "A text notification has been issued by the managed resource", genericDescriptor);
    }

    private static final ModelMBeanNotificationInfo makeAttributeChangeInfo() {
        DescriptorSupport attributeDescriptor = new DescriptorSupport(new String[]{"name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.attribute.change"});
        return new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Signifies that an observed MBean attribute value has changed", attributeDescriptor);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (RequiredModelMBean.tracing()) {
            this.trace("getNotificationInfo()", "Entry");
        }
        boolean hasGeneric = RequiredModelMBean.hasNotification(this.modelMBeanInfo, "GENERIC");
        boolean hasAttributeChange = RequiredModelMBean.hasNotification(this.modelMBeanInfo, "ATTRIBUTE_CHANGE");
        ModelMBeanNotificationInfo[] currInfo = (ModelMBeanNotificationInfo[])this.modelMBeanInfo.getNotifications();
        int len = (currInfo == null ? 0 : currInfo.length) + (hasGeneric ? 0 : 1) + (hasAttributeChange ? 0 : 1);
        MBeanNotificationInfo[] respInfo = new ModelMBeanNotificationInfo[len];
        int inserted = 0;
        if (!hasGeneric) {
            respInfo[inserted++] = RequiredModelMBean.makeGenericInfo();
        }
        if (!hasAttributeChange) {
            respInfo[inserted++] = RequiredModelMBean.makeAttributeChangeInfo();
        }
        int count = currInfo.length;
        int offset = inserted;
        for (int j = 0; j < count; ++j) {
            respInfo[offset + j] = currInfo[j];
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("getNotificationInfo()", "Exit");
        }
        return respInfo;
    }

    public void addAttributeChangeNotificationListener(NotificationListener inlistener, String inAttributeName, Object inhandback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        String ftag = "addAttributeChangeNotificationListener(NotificationListener, String, Object)";
        if (RequiredModelMBean.tracing()) {
            this.trace("addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Entry");
        }
        if (inlistener == null) {
            throw new IllegalArgumentException("Listener to be registered must not be null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new NotificationBroadcasterSupport();
        }
        AttributeChangeNotificationFilter currFilter = new AttributeChangeNotificationFilter();
        MBeanAttributeInfo[] attrInfo = this.modelMBeanInfo.getAttributes();
        boolean found = false;
        if (inAttributeName == null) {
            if (attrInfo != null && attrInfo.length > 0) {
                for (int i = 0; i < attrInfo.length; ++i) {
                    currFilter.enableAttribute(attrInfo[i].getName());
                }
            }
        } else if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                if (!inAttributeName.equals(attrInfo[i].getName())) continue;
                found = true;
                currFilter.enableAttribute(inAttributeName);
                break;
            }
            if (!found) {
                throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name does not exist"), "Exception occured trying to add an AttributeChangeNotification listener");
            }
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Set attribute change filter to " + currFilter.getEnabledAttributes().firstElement().toString());
        }
        this.attributeBroadcaster.addNotificationListener(inlistener, currFilter, inhandback);
        if (RequiredModelMBean.tracing()) {
            this.trace("addAttributeChangeNotificationListener", "added for " + inAttributeName);
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Exit");
        }
    }

    public void removeAttributeChangeNotificationListener(NotificationListener inlistener, String inAttributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        if (inlistener == null) {
            throw new ListenerNotFoundException("Notification listener is null");
        }
        String ftag = "removeAttributeChangeNotificationListener(NotificationListener, String)";
        if (RequiredModelMBean.tracing()) {
            this.trace("removeAttributeChangeNotificationListener(NotificationListener, String)", "Entry");
        }
        if (this.attributeBroadcaster == null) {
            throw new ListenerNotFoundException("No attribute change notification listeners registered");
        }
        MBeanAttributeInfo[] attrInfo = this.modelMBeanInfo.getAttributes();
        boolean found = false;
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                if (!attrInfo[i].getName().equals(inAttributeName)) continue;
                found = true;
                break;
            }
        }
        if (!found && inAttributeName != null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute name"), "Exception occured trying to remove attribute change notification listener");
        }
        this.attributeBroadcaster.removeNotificationListener(inlistener);
        if (RequiredModelMBean.tracing()) {
            this.trace("removeAttributeChangeNotificationListener(NotificationListener, String)", "Exit");
        }
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification ntfyObj) throws MBeanException, RuntimeOperationsException {
        String logfile;
        String logging;
        String ftag = "sendAttributeChangeNotification(AttributeChangeNotification)";
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Entry");
        }
        if (ntfyObj == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute change notification object must not be null"), "Exception occured trying to send attribute change notification of a ModelMBean");
        }
        Object oldv = ntfyObj.getOldValue();
        Object newv = ntfyObj.getNewValue();
        if (oldv == null) {
            oldv = "null";
        }
        if (newv == null) {
            newv = "null";
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Sending AttributeChangeNotification  with " + ntfyObj.getAttributeName() + ntfyObj.getAttributeType() + ntfyObj.getNewValue() + ntfyObj.getOldValue());
        }
        Descriptor ntfyDesc = this.modelMBeanInfo.getDescriptor(ntfyObj.getType(), "notification");
        Descriptor mmbDesc = this.modelMBeanInfo.getMBeanDescriptor();
        if (ntfyDesc != null) {
            String logging2 = (String)ntfyDesc.getFieldValue("log");
            if (logging2 == null && mmbDesc != null) {
                logging2 = (String)mmbDesc.getFieldValue("log");
            }
            if (logging2 != null && (logging2.equalsIgnoreCase("t") || logging2.equalsIgnoreCase("true"))) {
                String logfile2 = (String)ntfyDesc.getFieldValue("logfile");
                if (logfile2 == null && mmbDesc != null) {
                    logfile2 = (String)mmbDesc.getFieldValue("logfile");
                }
                if (logfile2 != null) {
                    try {
                        this.writeToLog(logfile2, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Name = " + ntfyObj.getAttributeName() + " Old value = " + oldv + " New value = " + newv);
                    }
                    catch (Exception e) {
                        this.error("sendAttributeChangeNotification(AttributeChangeNotification)", "Failed to log " + ntfyObj.getType() + " notification: " + e);
                        this.traceX("sendAttributeChangeNotification(AttributeChangeNotification)", e);
                    }
                }
            }
        } else if (mmbDesc != null && (logging = (String)mmbDesc.getFieldValue("log")) != null && (logging.equalsIgnoreCase("t") || logging.equalsIgnoreCase("true")) && (logfile = (String)mmbDesc.getFieldValue("logfile")) != null) {
            try {
                this.writeToLog(logfile, "LogMsg: " + new Date(ntfyObj.getTimeStamp()).toString() + " " + ntfyObj.getType() + " " + ntfyObj.getMessage() + " Name = " + ntfyObj.getAttributeName() + " Old value = " + oldv + " New value = " + newv);
            }
            catch (Exception e) {
                this.error("sendAttributeChangeNotification(AttributeChangeNotification)", "Failed to log " + ntfyObj.getType() + " notification: " + e);
                this.traceX("sendAttributeChangeNotification(AttributeChangeNotification)", e);
            }
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.sendNotification(ntfyObj);
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.sendNotification(ntfyObj);
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "sent notification");
        }
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Exit");
        }
    }

    public void sendAttributeChangeNotification(Attribute inOldVal, Attribute inNewVal) throws MBeanException, RuntimeOperationsException {
        String ftag = "sendAttributeChangeNotification(Attribute, Attribute)";
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute, Attribute)", "Entry");
        }
        if (inOldVal == null || inNewVal == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute object must not be null"), "Exception occured trying to send attribute change notification of a ModelMBean");
        }
        if (!inOldVal.getName().equals(inNewVal.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names are not the same"), "Exception occured trying to send attribute change notification of a ModelMBean");
        }
        Object newVal = inNewVal.getValue();
        Object oldVal = inOldVal.getValue();
        String className = "unknown";
        if (newVal != null) {
            className = newVal.getClass().getName();
        }
        if (oldVal != null) {
            className = oldVal.getClass().getName();
        }
        AttributeChangeNotification myNtfyObj = new AttributeChangeNotification(this, 1L, new Date().getTime(), "AttributeChangeDetected", inOldVal.getName(), className, inOldVal.getValue(), inNewVal.getValue());
        this.sendAttributeChangeNotification(myNtfyObj);
        if (RequiredModelMBean.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute, Attribute)", "Exit");
        }
    }

    protected ClassLoaderRepository getClassLoaderRepository() {
        return MBeanServerFactory.getClassLoaderRepository(this.server);
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoaderRepository clr = this.getClassLoaderRepository();
            if (clr == null) {
                throw new ClassNotFoundException(className);
            }
            return clr.loadClass(className);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            throw new NullPointerException("name of RequiredModelMBean to registered is null");
        }
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        this.registered = registrationDone;
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.registered = false;
        this.server = null;
    }

    private static final boolean tracing() {
        return Trace.isSelected(1, 128);
    }

    private void trace(String inClass, String inMethod, String inText) {
        Trace.send(1, 128, inClass, inMethod, Integer.toHexString(this.hashCode()) + " " + inText);
    }

    private void traceX(String inMethod, Throwable x) {
        Trace.send(1, 128, this.currClass, inMethod, x);
    }

    private void trace(String inMethod, String inText) {
        this.trace(this.currClass, inMethod, inText);
    }

    private void error(String inMethod, String inText) {
        Trace.send(0, 128, this.currClass, inMethod, Integer.toHexString(this.hashCode()) + " " + inText);
    }

    private boolean debugging() {
        return Trace.isSelected(2, 128);
    }

    private void debug(String inClass, String inMethod, String inText) {
        Trace.send(2, 128, inClass, inMethod, Integer.toHexString(this.hashCode()) + " " + inText);
    }

    private void debug(String inMethod, String inText) {
        this.debug(this.currClass, inMethod, inText);
    }

    private void debug(String inMethod, Throwable x) {
        Trace.send(2, 128, this.currClass, inMethod, x);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

