/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class StandardMBean
implements DynamicMBean {
    private static final String dbgTag = "StandardMBean";
    private Class mbeanInterface;
    private Object implementation;
    private final StandardMetaDataImpl meta;
    private MBeanInfo cachedMBeanInfo;

    private StandardMBean(Object implementation, Class mbeanInterface, boolean nullImplementationAllowed) throws NotCompliantMBeanException {
        if (implementation == null) {
            if (nullImplementationAllowed) {
                implementation = this;
            } else {
                throw new IllegalArgumentException("implementation is null");
            }
        }
        this.meta = new StandardMBeanMeta();
        this.setImplementation(implementation, mbeanInterface);
    }

    public StandardMBean(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        this(implementation, mbeanInterface, false);
    }

    protected StandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        this(null, mbeanInterface, true);
    }

    public synchronized void setImplementation(Object implementation) throws NotCompliantMBeanException {
        this.setImplementation(implementation, this.getMBeanInterface());
    }

    private synchronized void setImplementation(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        this.meta.testCompliance(implementation.getClass(), mbeanInterface);
        this.cacheMBeanInfo(null);
        this.implementation = implementation;
        this.mbeanInterface = mbeanInterface;
        if (this.mbeanInterface == null) {
            this.mbeanInterface = this.meta.getStandardMBeanInterface(implementation.getClass());
        }
    }

    public synchronized Object getImplementation() {
        return this.implementation;
    }

    public final synchronized Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public synchronized Class getImplementationClass() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getClass();
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.meta.getAttribute(this.getImplementation(), attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.meta.setAttribute(this.getImplementation(), attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.meta.getAttributes(this.getImplementation(), attributes);
        }
        catch (ReflectionException x) {
            UndeclaredThrowableException r = new UndeclaredThrowableException(x, x.getMessage());
            throw new RuntimeOperationsException(r, x.getMessage());
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.meta.setAttributes(this.getImplementation(), attributes);
        }
        catch (ReflectionException x) {
            UndeclaredThrowableException r = new UndeclaredThrowableException(x, x.getMessage());
            throw new RuntimeOperationsException(r, x.getMessage());
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.meta.invoke(this.getImplementation(), actionName, params, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() {
        MBeanInfo bi;
        Object impl;
        try {
            MBeanInfo cached = this.getCachedMBeanInfo();
            if (cached != null) {
                return cached;
            }
        }
        catch (RuntimeException x) {
            StandardMBean.debug("getMBeanInfo", "failed to get cached MBeanInfo: " + x);
            StandardMBean.debugX("getMBeanInfo", x);
        }
        if (StandardMBean.isTraceOn()) {
            StandardMBean.trace("getMBeanInfo", "Building MBeanInfo for " + this.getImplementationClass().getName());
        }
        try {
            StandardMBean standardMBean = this;
            synchronized (standardMBean) {
                impl = this.getImplementation();
                bi = this.buildStandardMBeanInfo();
            }
        }
        catch (NotCompliantMBeanException x) {
            UndeclaredThrowableException r = new UndeclaredThrowableException(x, x.getMessage());
            throw new RuntimeOperationsException(r, x.getMessage());
        }
        String cname = this.getClassName(bi);
        String text = this.getDescription(bi);
        MBeanConstructorInfo[] ctors = this.getConstructors(bi, impl);
        MBeanAttributeInfo[] attrs = this.getAttributes(bi);
        MBeanOperationInfo[] ops = this.getOperations(bi);
        MBeanNotificationInfo[] ntfs = this.getNotifications(bi);
        MBeanInfo nmbi = new MBeanInfo(cname, text, attrs, ctors, ops, ntfs);
        try {
            this.cacheMBeanInfo(nmbi);
        }
        catch (RuntimeException x) {
            StandardMBean.debug("cacheMBeanInfo", "failed to cache MBeanInfo: " + x);
            StandardMBean.debugX("cacheMBeanInfo", x);
        }
        return nmbi;
    }

    protected String getClassName(MBeanInfo info) {
        if (info == null) {
            return this.getImplementationClass().getName();
        }
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo ctor, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo ctor, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected int getImpact(MBeanOperationInfo info) {
        if (info == null) {
            return 3;
        }
        return info.getImpact();
    }

    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getDescription();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] ctors, Object impl) {
        if (ctors == null) {
            return null;
        }
        if (impl != null && impl != this) {
            return null;
        }
        return ctors;
    }

    private MBeanNotificationInfo[] getNotifications(MBeanInfo info) {
        if (info == null) {
            return null;
        }
        return info.getNotifications();
    }

    protected synchronized MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected synchronized void cacheMBeanInfo(MBeanInfo info) {
        this.cachedMBeanInfo = info;
    }

    private synchronized MBeanInfo buildStandardMBeanInfo() throws NotCompliantMBeanException {
        return this.meta.buildMBeanInfo(this.getImplementationClass(), this.getMBeanInterface());
    }

    private MBeanConstructorInfo[] getConstructors(MBeanInfo info, Object impl) {
        MBeanConstructorInfo[] nctors;
        MBeanConstructorInfo[] ctors = this.getConstructors(info.getConstructors(), impl);
        if (ctors != null) {
            int ctorlen = ctors.length;
            nctors = new MBeanConstructorInfo[ctorlen];
            for (int i = 0; i < ctorlen; ++i) {
                MBeanParameterInfo[] nps;
                MBeanConstructorInfo c = ctors[i];
                MBeanParameterInfo[] params = c.getSignature();
                if (params != null) {
                    int plen = params.length;
                    nps = new MBeanParameterInfo[plen];
                    for (int ii = 0; ii < plen; ++ii) {
                        MBeanParameterInfo p = params[ii];
                        String name = this.getParameterName(c, p, ii);
                        String text = this.getDescription(c, p, ii);
                        nps[ii] = new MBeanParameterInfo(name, p.getType(), text);
                    }
                } else {
                    nps = null;
                }
                nctors[i] = new MBeanConstructorInfo(c.getName(), this.getDescription(c), nps);
            }
        } else {
            nctors = null;
        }
        return nctors;
    }

    private MBeanOperationInfo[] getOperations(MBeanInfo info) {
        MBeanOperationInfo[] nops;
        MBeanOperationInfo[] ops = info.getOperations();
        if (ops != null) {
            int oplen = ops.length;
            nops = new MBeanOperationInfo[oplen];
            for (int i = 0; i < oplen; ++i) {
                MBeanParameterInfo[] nps;
                MBeanOperationInfo o = ops[i];
                MBeanParameterInfo[] params = o.getSignature();
                if (params != null) {
                    int plen = params.length;
                    nps = new MBeanParameterInfo[plen];
                    for (int ii = 0; ii < plen; ++ii) {
                        MBeanParameterInfo p = params[ii];
                        String name = this.getParameterName(o, p, ii);
                        String text = this.getDescription(o, p, ii);
                        nps[ii] = new MBeanParameterInfo(name, p.getType(), text);
                    }
                } else {
                    nps = null;
                }
                nops[i] = new MBeanOperationInfo(o.getName(), this.getDescription(o), nps, o.getReturnType(), this.getImpact(o));
            }
        } else {
            nops = null;
        }
        return nops;
    }

    private MBeanAttributeInfo[] getAttributes(MBeanInfo info) {
        MBeanAttributeInfo[] natts;
        MBeanAttributeInfo[] atts = info.getAttributes();
        if (atts != null) {
            int attlen = atts.length;
            natts = new MBeanAttributeInfo[attlen];
            for (int i = 0; i < attlen; ++i) {
                MBeanAttributeInfo a = atts[i];
                natts[i] = new MBeanAttributeInfo(a.getName(), a.getType(), this.getDescription(a), a.isReadable(), a.isWritable(), a.isIs());
            }
        } else {
            natts = null;
        }
        return natts;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 16);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 16, clz, func, info);
    }

    private static void trace(String func, String info) {
        StandardMBean.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 16);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 16, clz, func, info);
    }

    private static void debug(String func, String info) {
        StandardMBean.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (StandardMBean.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            StandardMBean.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            StandardMBean.debug(dbgTag, func, stack);
        }
    }

    private final class StandardMBeanMeta
    extends StandardMetaDataImpl {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MBeanInfo getCachedMBeanInfo(Class beanClass) {
            if (beanClass == null) {
                return null;
            }
            StandardMBean standardMBean = StandardMBean.this;
            synchronized (standardMBean) {
                Class implementationClass = StandardMBean.this.getImplementationClass();
                if (implementationClass == null) {
                    return null;
                }
                if (!beanClass.equals(implementationClass)) {
                    return null;
                }
                return StandardMBean.this.getMBeanInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class getCachedMBeanInterface(Class beanClass) {
            StandardMBean standardMBean = StandardMBean.this;
            synchronized (standardMBean) {
                Class implementationClass = StandardMBean.this.getImplementationClass();
                if (implementationClass == null) {
                    return null;
                }
                if (!beanClass.equals(implementationClass)) {
                    return null;
                }
                return StandardMBean.this.getMBeanInterface();
            }
        }

        protected void cacheMBeanInfo(Class c, Class mbeanInterface, MBeanInfo mbeanInfo) {
        }
    }
}

