/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AndQueryExp;
import javax.management.AttributeValueExp;
import javax.management.BetweenQueryExp;
import javax.management.BinaryOpValueExp;
import javax.management.BinaryRelQueryExp;
import javax.management.BooleanValueExp;
import javax.management.ClassAttributeValueExp;
import javax.management.InQueryExp;
import javax.management.MatchQueryExp;
import javax.management.NotQueryExp;
import javax.management.NumericValueExp;
import javax.management.OrQueryExp;
import javax.management.QualifiedAttributeValueExp;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class Query {
    public static final int GT = 0;
    public static final int LT = 1;
    public static final int GE = 2;
    public static final int LE = 3;
    public static final int EQ = 4;
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;

    public static QueryExp and(QueryExp q1, QueryExp q2) {
        return new AndQueryExp(q1, q2);
    }

    public static QueryExp or(QueryExp q1, QueryExp q2) {
        return new OrQueryExp(q1, q2);
    }

    public static QueryExp gt(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(0, v1, v2);
    }

    public static QueryExp geq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(2, v1, v2);
    }

    public static QueryExp leq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(3, v1, v2);
    }

    public static QueryExp lt(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(1, v1, v2);
    }

    public static QueryExp eq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(4, v1, v2);
    }

    public static QueryExp between(ValueExp v1, ValueExp v2, ValueExp v3) {
        return new BetweenQueryExp(v1, v2, v3);
    }

    public static QueryExp match(AttributeValueExp a, StringValueExp s) {
        return new MatchQueryExp(a, s);
    }

    public static AttributeValueExp attr(String name) {
        return new AttributeValueExp(name);
    }

    public static AttributeValueExp attr(String className, String name) {
        return new QualifiedAttributeValueExp(className, name);
    }

    public static AttributeValueExp classattr() {
        return new ClassAttributeValueExp();
    }

    public static QueryExp not(QueryExp queryExp) {
        return new NotQueryExp(queryExp);
    }

    public static QueryExp in(ValueExp val, ValueExp[] valueList) {
        return new InQueryExp(val, valueList);
    }

    public static StringValueExp value(String val) {
        return new StringValueExp(val);
    }

    public static ValueExp value(Number val) {
        return new NumericValueExp(val);
    }

    public static ValueExp value(int val) {
        return new NumericValueExp(new Long(val));
    }

    public static ValueExp value(long val) {
        return new NumericValueExp(new Long(val));
    }

    public static ValueExp value(float val) {
        return new NumericValueExp(new Double(val));
    }

    public static ValueExp value(double val) {
        return new NumericValueExp(new Double(val));
    }

    public static ValueExp value(boolean val) {
        return new BooleanValueExp(val);
    }

    public static ValueExp plus(ValueExp value1, ValueExp value2) {
        return new BinaryOpValueExp(0, value1, value2);
    }

    public static ValueExp times(ValueExp value1, ValueExp value2) {
        return new BinaryOpValueExp(2, value1, value2);
    }

    public static ValueExp minus(ValueExp value1, ValueExp value2) {
        return new BinaryOpValueExp(1, value1, value2);
    }

    public static ValueExp div(ValueExp value1, ValueExp value2) {
        return new BinaryOpValueExp(3, value1, value2);
    }

    public static QueryExp initialSubString(AttributeValueExp a, StringValueExp s) {
        return new MatchQueryExp(a, new StringValueExp(s.getValue() + "*"));
    }

    public static QueryExp anySubString(AttributeValueExp a, StringValueExp s) {
        return new MatchQueryExp(a, new StringValueExp("*" + s.getValue() + "*"));
    }

    public static QueryExp finalSubString(AttributeValueExp a, StringValueExp s) {
        return new MatchQueryExp(a, new StringValueExp("*" + s.getValue()));
    }
}

