/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.trace.Trace;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerFactory {
    private static MBeanServerBuilder builder;
    private static final ObjectName delegateName;
    private static final ArrayList mBeanServerList;
    static /* synthetic */ Class class$javax$management$MBeanServerBuilder;
    static /* synthetic */ Class class$javax$management$MBeanServerFactory;

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission("releaseMBeanServer");
        MBeanServerFactory.removeMBeanServer(mbeanServer);
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer(domain);
        MBeanServerFactory.addMBeanServer(mBeanServer);
        return mBeanServer;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerBuilder mbsBuilder;
        MBeanServerFactory.checkPermission("newMBeanServer");
        MBeanServerBuilder mBeanServerBuilder = mbsBuilder = MBeanServerFactory.getNewMBeanServerBuilder();
        synchronized (mBeanServerBuilder) {
            MBeanServerDelegate delegate = mbsBuilder.newMBeanServerDelegate();
            if (delegate == null) {
                String msg = "MBeanServerBuilder.newMBeanServerDelegate() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServerDelegate() returned null");
            }
            MBeanServer mbeanServer = mbsBuilder.newMBeanServer(domain, null, delegate);
            if (mbeanServer == null) {
                String msg = "MBeanServerBuilder.newMBeanServer() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServer() returned null");
            }
            return mbeanServer;
        }
    }

    public static synchronized ArrayList findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission("findMBeanServer");
        if (agentId == null) {
            return (ArrayList)mBeanServerList.clone();
        }
        ArrayList<MBeanServer> result = new ArrayList<MBeanServer>();
        Iterator i = mBeanServerList.iterator();
        while (i.hasNext()) {
            MBeanServer mbs = (MBeanServer)i.next();
            String name = MBeanServerFactory.mBeanServerName(mbs);
            if (!agentId.equals(name)) continue;
            result.add(mbs);
        }
        return result;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static String mBeanServerName(MBeanServer mbs) {
        try {
            return (String)mbs.getAttribute(delegateName, "MBeanServerId");
        }
        catch (JMException e) {
            return null;
        }
    }

    private static void checkPermission(String action) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanServerPermission perm = new MBeanServerPermission(action);
            sm.checkPermission(perm);
        }
    }

    private static synchronized void addMBeanServer(MBeanServer mbs) {
        mBeanServerList.add(mbs);
    }

    private static synchronized void removeMBeanServer(MBeanServer mbs) {
        boolean removed = mBeanServerList.remove(mbs);
        if (!removed) {
            MBeanServerFactory.trace("removeMBeanServer", "MBeanServer was not in list!");
        }
    }

    private static Class loadBuilderClass(String builderClassName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader.loadClass(builderClassName);
        }
        return Class.forName(builderClassName);
    }

    private static MBeanServerBuilder newBuilder(Class builderClass) {
        try {
            Object builder = builderClass.newInstance();
            return (MBeanServerBuilder)builder;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            String msg = "Failed to instantiate a MBeanServerBuilder from " + builderClass + ": " + x;
            throw new JMRuntimeException(msg, x);
        }
    }

    private static synchronized void checkMBeanServerBuilder() {
        try {
            GetPropertyAction act = new GetPropertyAction("javax.management.builder.initial");
            String builderClassName = (String)AccessController.doPrivileged(act);
            try {
                Class<?> builderClass;
                Class newBuilderClass = builderClassName == null || builderClassName.length() == 0 ? (class$javax$management$MBeanServerBuilder == null ? (class$javax$management$MBeanServerBuilder = MBeanServerFactory.class$("javax.management.MBeanServerBuilder")) : class$javax$management$MBeanServerBuilder) : MBeanServerFactory.loadBuilderClass(builderClassName);
                if (builder != null && newBuilderClass == (builderClass = builder.getClass())) {
                    return;
                }
                builder = MBeanServerFactory.newBuilder(newBuilderClass);
            }
            catch (ClassNotFoundException x) {
                String msg = "Failed to load MBeanServerBuilder class " + builderClassName + ": " + x;
                throw new JMRuntimeException(msg, x);
            }
        }
        catch (RuntimeException x) {
            MBeanServerFactory.debug("checkMBeanServerBuilder", "Failed to instantiate MBeanServerBuilder: " + x + "\n\t\tCheck the value of the " + "javax.management.builder.initial" + " property.");
            throw x;
        }
    }

    private static synchronized MBeanServerBuilder getNewMBeanServerBuilder() {
        MBeanServerFactory.checkMBeanServerBuilder();
        return builder;
    }

    private static void trace(String method, String message) {
        if (Trace.isSelected(1, 1)) {
            Trace.send(1, 1, (class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName(), method, message);
        }
    }

    private static void debug(String method, String message) {
        if (Trace.isSelected(2, 1)) {
            Trace.send(2, 1, (class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName(), method, message);
        }
    }

    private static void error(String method, String message) {
        if (Trace.isSelected(0, 1)) {
            Trace.send(0, 1, (class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName(), method, message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ObjectName name;
        builder = null;
        try {
            name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (JMException e) {
            name = null;
            MBeanServerFactory.trace("<clinit>", "internal error creating delegate ObjectName: " + e);
        }
        delegateName = name;
        mBeanServerList = new ArrayList();
    }
}

