/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class AttributeChangeNotificationFilter
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = -6347317584796410029L;
    private Vector enabledAttributes = new Vector();

    public synchronized boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        if (type == null || !type.equals(AttributeChangeNotification.ATTRIBUTE_CHANGE) || !(notification instanceof AttributeChangeNotification)) {
            return false;
        }
        String attributeName = ((AttributeChangeNotification)notification).getAttributeName();
        return this.enabledAttributes.contains(attributeName);
    }

    public synchronized void enableAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        if (!this.enabledAttributes.contains(name)) {
            this.enabledAttributes.addElement(name);
        }
    }

    public synchronized void disableAttribute(String name) {
        this.enabledAttributes.removeElement(name);
    }

    public synchronized void disableAllAttributes() {
        this.enabledAttributes.removeAllElements();
    }

    public synchronized Vector getEnabledAttributes() {
        return this.enabledAttributes;
    }
}

