/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.trace;

import com.sun.jmx.trace.TraceDestination;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceManager
implements TraceDestination {
    private static Level getLevel(int level) {
        switch (level) {
            case 2: {
                return Level.FINEST;
            }
            case 1: {
                return Level.FINER;
            }
            case 0: {
                return Level.SEVERE;
            }
        }
        return null;
    }

    private static Logger getLogger(int type) {
        switch (type) {
            case 1: {
                return Logger.getLogger("javax.management.mbeanserver");
            }
            case 2: {
                return Logger.getLogger("javax.management.mlet");
            }
            case 4: {
                return Logger.getLogger("javax.management.monitor");
            }
            case 8: {
                return Logger.getLogger("javax.management.timer");
            }
            case 16: {
                return Logger.getLogger("javax.management.misc");
            }
            case 32: {
                return Logger.getLogger("javax.management.notification");
            }
            case 64: {
                return Logger.getLogger("javax.management.relation");
            }
            case 128: {
                return Logger.getLogger("javax.management.modelmbean");
            }
        }
        return null;
    }

    public boolean isSelected(int level, int type) {
        Level lvl;
        Logger logger = TraceManager.getLogger(type);
        if (logger != null && (lvl = TraceManager.getLevel(level)) != null) {
            return logger.isLoggable(lvl);
        }
        return false;
    }

    public boolean send(int level, int type, String className, String methodName, String info) {
        if (this.isSelected(level, type)) {
            TraceManager.getLogger(type).logp(TraceManager.getLevel(level), className, methodName, info);
            return true;
        }
        return false;
    }

    public boolean send(int level, int type, String className, String methodName, Throwable exception) {
        if (this.isSelected(level, type)) {
            TraceManager.getLogger(type).log(TraceManager.getLevel(level), className + ": Exception occured in " + methodName, exception);
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
    }

    void warning(String loggerName, String msg) {
        Logger.getLogger(loggerName).warning(msg);
    }

    void fine(String loggerName, String msg) {
        Logger.getLogger(loggerName).fine(msg);
    }
}

