/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.trace;

import com.sun.jmx.trace.Trace;
import com.sun.jmx.trace.TraceDestination;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TraceImplementation
implements TraceDestination {
    private PrintWriter out;
    private int level;

    static TraceImplementation newDestination(int level) {
        try {
            TraceImplementation impl = new TraceImplementation();
            impl.level = level;
            return impl;
        }
        catch (IOException x) {
            return null;
        }
    }

    public static void init() throws IOException {
        Trace.setDestination(new TraceImplementation());
    }

    public static void init(int level) throws IOException {
        TraceImplementation impl = new TraceImplementation();
        impl.level = level;
        Trace.setDestination(impl);
    }

    public TraceImplementation() throws IOException {
        String filename = System.getProperty("com.sun.jmx.trace.file");
        this.out = filename != null ? new PrintWriter(new FileOutputStream(filename), true) : new PrintWriter(System.err, true);
        String level = System.getProperty("com.sun.jmx.trace.level");
        this.level = level != null ? (level.equals("DEBUG") ? 2 : (level.equals("TRACE") ? 1 : 0)) : 0;
    }

    public boolean isSelected(int level, int type) {
        return level <= this.level;
    }

    public boolean send(int level, int type, String className, String methodName, String info) {
        if (this.isSelected(level, type)) {
            this.out.println((className != null ? "Class:  " + className : "") + (methodName != null ? "\nMethod: " + methodName : "") + "\n\tlevel:   " + TraceImplementation.getLevel(level) + "\n\ttype:    " + TraceImplementation.getType(type) + "\n\tmessage: " + info);
            return true;
        }
        return false;
    }

    public boolean send(int level, int type, String className, String methodName, Throwable exception) {
        boolean result = this.send(level, type, className, methodName, exception.toString());
        if (result) {
            exception.printStackTrace(this.out);
        }
        return result;
    }

    public void reset() throws IOException {
    }

    private static String getType(int type) {
        switch (type) {
            case 1: {
                return "INFO_MBEANSERVER";
            }
            case 2: {
                return "INFO_MLET";
            }
            case 4: {
                return "INFO_MONITOR";
            }
            case 8: {
                return "INFO_TIMER";
            }
            case 16: {
                return "INFO_MISC";
            }
            case 32: {
                return "INFO_NOTIFICATION";
            }
            case 64: {
                return "INFO_RELATION";
            }
            case 128: {
                return "INFO_MODELMBEAN";
            }
        }
        return "UNKNOWN_TRACE_TYPE";
    }

    private static String getLevel(int level) {
        switch (level) {
            case 0: {
                return "LEVEL_ERROR";
            }
            case 1: {
                return "LEVEL_TRACE";
            }
            case 2: {
                return "LEVEL_DEBUG";
            }
        }
        return "UNKNOWN_TRACE_LEVEL";
    }
}

