/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.BaseMetaDataImpl;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiatorImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class StandardMetaDataImpl
extends BaseMetaDataImpl {
    private static final String dbgTag = "StandardMetaDataImpl";
    private static Map mbeanInfoCache = new WeakHashMap();
    private static Map mbeanInterfaceCache = new WeakHashMap();
    private static final Hashtable primitiveClasses = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;

    public StandardMetaDataImpl() {
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
    }

    public synchronized MBeanInfo buildMBeanInfo(Class c) throws NotCompliantMBeanException {
        return Introspector.testCompliance(c);
    }

    public synchronized MBeanInfo buildMBeanInfo(Class c, Class mbeanInterface) throws NotCompliantMBeanException {
        return Introspector.testCompliance(c, mbeanInterface);
    }

    public synchronized void testCompliance(Class c) throws NotCompliantMBeanException {
        MBeanInfo mbeanInfo = this.buildMBeanInfo(c);
        Class mbeanInterface = Introspector.getMBeanInterface(c);
        this.cacheMBeanInfo(c, mbeanInterface, mbeanInfo);
    }

    public synchronized void testCompliance(Class c, Class mbeanInterface) throws NotCompliantMBeanException {
        MBeanInfo mbeanInfo = this.buildMBeanInfo(c, mbeanInterface);
        if (mbeanInterface == null) {
            mbeanInterface = Introspector.getStandardMBeanInterface(c);
        }
        this.cacheMBeanInfo(c, mbeanInterface, mbeanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getMBeanInterfaceFromClass(Class c) {
        Class itf = this.getCachedMBeanInterface(c);
        if (itf != null) {
            return itf;
        }
        StandardMetaDataImpl standardMetaDataImpl = this;
        synchronized (standardMetaDataImpl) {
            return Introspector.getMBeanInterface(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getStandardMBeanInterface(Class c) {
        StandardMetaDataImpl standardMetaDataImpl = this;
        synchronized (standardMetaDataImpl) {
            return Introspector.getStandardMBeanInterface(c);
        }
    }

    public MBeanInfo getMBeanInfoFromClass(Class beanClass) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo bi = this.getCachedMBeanInfo(beanClass);
        if (bi != null) {
            return (MBeanInfo)bi.clone();
        }
        this.testCompliance(beanClass);
        bi = this.getCachedMBeanInfo(beanClass);
        if (bi != null) {
            return (MBeanInfo)bi.clone();
        }
        return bi;
    }

    public String getMBeanClassName(Object moi) throws IntrospectionException, NotCompliantMBeanException {
        return moi.getClass().getName();
    }

    public MBeanInfo getMBeanInfo(Object moi) throws IntrospectionException {
        try {
            MBeanInfo mbi = this.getMBeanInfoFromClass(moi.getClass());
            return new MBeanInfo(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), this.findNotifications(moi));
        }
        catch (NotCompliantMBeanException x) {
            StandardMetaDataImpl.debugX("getMBeanInfo", x);
            throw new IntrospectionException("Can't build MBeanInfo for " + moi.getClass().getName());
        }
    }

    public Object getAttribute(Object instance, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        Class mbeanClass = this.getMBeanInterfaceFromInstance(instance);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("getAttribute", "MBean Class is " + instance.getClass());
            StandardMetaDataImpl.debug("getAttribute", "MBean Interface is " + mbeanClass);
        }
        return this.getAttribute(instance, attribute, mbeanClass);
    }

    public AttributeList getAttributes(Object instance, String[] attributes) throws ReflectionException {
        Class mbeanClass = this.getMBeanInterfaceFromInstance(instance);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("getAttributes", "MBean Class is " + instance.getClass());
            StandardMetaDataImpl.debug("getAttributes", "MBean Interface is " + mbeanClass);
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        int maxLimit = attributes.length;
        AttributeList result = new AttributeList(maxLimit);
        for (int i = 0; i < maxLimit; ++i) {
            String elmt = attributes[i];
            try {
                Object value = this.getAttribute(instance, elmt, mbeanClass);
                result.add(new Attribute(elmt, value));
                continue;
            }
            catch (Exception excep) {
                if (!StandardMetaDataImpl.isDebugOn()) continue;
                StandardMetaDataImpl.debug("getAttributes", "Object= " + instance + ", Attribute=" + elmt + " failed: " + excep);
            }
        }
        return result;
    }

    public AttributeList setAttributes(Object instance, AttributeList attributes) throws ReflectionException {
        Class<?> objClass = instance.getClass();
        Class mbeanClass = this.getMBeanInterfaceFromInstance(instance);
        ClassLoader aLoader = objClass.getClassLoader();
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("setAttributes", "MBean Class is " + instance.getClass());
            StandardMetaDataImpl.debug("setAttributes", "MBean Interface is " + mbeanClass);
        }
        if (attributes == null) {
            return new AttributeList();
        }
        AttributeList result = new AttributeList(attributes.size());
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            String id = attr.getName();
            Object value = attr.getValue();
            try {
                Object newValue = this.setAttribute(instance, attr, mbeanClass);
                if (StandardMetaDataImpl.isTraceOn()) {
                    StandardMetaDataImpl.trace("setAttributes", "Updating the list\n");
                }
                result.add(new Attribute(id, newValue));
            }
            catch (Exception excep) {
                if (!StandardMetaDataImpl.isDebugOn()) continue;
                StandardMetaDataImpl.debug("setAttributes", "Unexpected exception occured: " + excep.getClass().getName());
            }
        }
        return result;
    }

    public Object setAttribute(Object instance, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class mbeanClass = this.getMBeanInterfaceFromInstance(instance);
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("setAttribute", "MBean Class is " + instance.getClass());
            StandardMetaDataImpl.debug("setAttribute", "MBean Interface is " + mbeanClass);
        }
        return this.setAttribute(instance, attribute, mbeanClass);
    }

    public Object invoke(Object instance, String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Class[] tab;
        Method mth;
        if (operationName == null) {
            IllegalArgumentException r = new IllegalArgumentException("Operation name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occured trying to invoke the operation on the MBean");
        }
        Class<?> objClass = instance.getClass();
        Class mbeanClass = this.getMBeanInterfaceFromInstance(instance);
        ClassLoader aLoader = objClass.getClassLoader();
        if (StandardMetaDataImpl.isDebugOn()) {
            StandardMetaDataImpl.debug("invoke", "MBean Class is " + instance.getClass());
            StandardMetaDataImpl.debug("invoke", "MBean Interface is " + mbeanClass);
        }
        if ((mth = StandardMetaDataImpl.findMethod(mbeanClass, operationName, tab = signature == null ? null : this.findSignatureClasses(signature, aLoader))) == null) {
            if (StandardMetaDataImpl.isTraceOn()) {
                StandardMetaDataImpl.trace("invoke", operationName + " not found in class " + mbeanClass.getName());
            }
            throw new ReflectionException(new NoSuchMethodException(operationName), "The operation with name " + operationName + " could not be found");
        }
        StandardMetaDataImpl.forbidInvokeGetterSetter(mth, operationName);
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("invoke", "Invoking " + operationName);
        }
        Object result = null;
        try {
            result = mth.invoke(instance, params);
        }
        catch (IllegalAccessException e) {
            StandardMetaDataImpl.debugX("invoke", e);
            throw new ReflectionException(e, "IllegalAccessException occured trying to invoke operation " + operationName);
        }
        catch (RuntimeException e) {
            StandardMetaDataImpl.debugX("invoke", e);
            throw new RuntimeOperationsException(e, "RuntimeException occured trying to invoke operation " + operationName);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            StandardMetaDataImpl.debugX("invoke", t);
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in operation " + operationName);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in operation " + operationName);
            }
            throw new MBeanException((Exception)t, "Exception thrown in operation " + operationName);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("invoke", "Send the result");
        }
        return result;
    }

    private static boolean startsWithAndHasMore(String s, String prefix) {
        return s.startsWith(prefix) && s.length() > prefix.length();
    }

    private static void forbidInvokeGetterSetter(Method mth, String operationName) throws ReflectionException {
        Class<?>[] argTypes = mth.getParameterTypes();
        Class<?> resultType = mth.getReturnType();
        int argCount = argTypes.length;
        boolean isInvokeGetterSetter = false;
        switch (argCount) {
            case 0: {
                if ((!StandardMetaDataImpl.startsWithAndHasMore(operationName, "get") || resultType == Void.TYPE) && (!StandardMetaDataImpl.startsWithAndHasMore(operationName, "is") || resultType != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StandardMetaDataImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean) && resultType != Boolean.TYPE)) break;
                isInvokeGetterSetter = true;
                break;
            }
            case 1: {
                if (!StandardMetaDataImpl.startsWithAndHasMore(operationName, "set") || resultType != Void.TYPE) break;
                isInvokeGetterSetter = true;
            }
        }
        if (isInvokeGetterSetter) {
            boolean allow;
            try {
                GetPropertyAction getProp = new GetPropertyAction("jmx.invoke.getters");
                allow = AccessController.doPrivileged(getProp) != null;
            }
            catch (SecurityException e) {
                allow = false;
            }
            if (!allow) {
                String msg = "Cannot invoke getter or setter (" + operationName + ") as operation unless jmx.invoke.getters property is set";
                NoSuchMethodException nested = new NoSuchMethodException(operationName);
                throw new ReflectionException(nested, msg);
            }
        }
    }

    public boolean isInstanceOf(Object instance, String className) throws ReflectionException {
        Class c = this.findClass(className, instance.getClass().getClassLoader());
        return c.isInstance(instance);
    }

    protected Class getMBeanInterfaceFromInstance(Object instance) {
        if (instance == null) {
            return null;
        }
        return this.getMBeanInterfaceFromClass(instance.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheMBeanInfo(Class c, Class mbeanInterface, MBeanInfo info) throws NotCompliantMBeanException {
        Map map;
        if (info != null) {
            map = mbeanInfoCache;
            synchronized (map) {
                if (mbeanInfoCache.get(c) == null) {
                    mbeanInfoCache.put(c, info);
                }
            }
        }
        if (mbeanInterface != null) {
            map = mbeanInterfaceCache;
            synchronized (map) {
                if (mbeanInterfaceCache.get(c) == null || ((WeakReference)mbeanInterfaceCache.get(c)).get() == null) {
                    mbeanInterfaceCache.put(c, new WeakReference<Class>(mbeanInterface));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getCachedMBeanInterface(Class c) {
        Map map = mbeanInterfaceCache;
        synchronized (map) {
            return (Class)((WeakReference)mbeanInterfaceCache.get(c)).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanInfo getCachedMBeanInfo(Class c) {
        Map map = mbeanInfoCache;
        synchronized (map) {
            return (MBeanInfo)mbeanInfoCache.get(c);
        }
    }

    protected Class findClass(String className, ClassLoader loader) throws ReflectionException {
        return MBeanInstantiatorImpl.loadClass(className, loader);
    }

    protected Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        return signature == null ? null : MBeanInstantiatorImpl.loadSignatureClasses(signature, loader);
    }

    protected Object getAttribute(Object instance, String attribute, Class mbeanClass) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occured trying to invoke the getter on the MBean");
        }
        Method meth = null;
        meth = StandardMetaDataImpl.findGetter(mbeanClass, attribute);
        if (meth == null) {
            if (StandardMetaDataImpl.isTraceOn()) {
                StandardMetaDataImpl.trace("getAttribute", "Cannot find getter for " + attribute + " in class " + mbeanClass.getName());
            }
            throw new AttributeNotFoundException(attribute + " not accessible");
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("getAttribute", "Invoke callback");
        }
        Object result = null;
        try {
            result = meth.invoke(instance, null);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                StandardMetaDataImpl.debugX("getAttribute", t);
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the getter for the attribute " + attribute);
            }
            if (t instanceof Error) {
                StandardMetaDataImpl.debugX("getAttribute", t);
                throw new RuntimeErrorException((Error)t, "Error thrown in the getter for the attribute " + attribute);
            }
            StandardMetaDataImpl.debugX("getAttribute", t);
            throw new MBeanException((Exception)t, "Exception thrown in the getter for the attribute " + attribute);
        }
        catch (RuntimeException e) {
            StandardMetaDataImpl.debugX("getAttribute", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown trying to invoke the getter for the attribute " + attribute);
        }
        catch (IllegalAccessException e) {
            StandardMetaDataImpl.debugX("getAttribute", e);
            throw new ReflectionException(e, "Exception thrown trying to invoke the getter for the attribute " + attribute);
        }
        catch (Error e) {
            StandardMetaDataImpl.debugX("getAttribute", e);
            throw new RuntimeErrorException(e, "Error thrown trying to invoke the getter  for the attribute " + attribute);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("getAttribute", attribute + "= " + result + "\n");
        }
        return result;
    }

    protected Object setAttribute(Object instance, Attribute attribute, Class mbeanClass) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class primClass;
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occured trying to invoke the setter on the MBean");
        }
        Class<?> objClass = instance.getClass();
        ClassLoader aLoader = objClass.getClassLoader();
        Object result = null;
        Object value = attribute.getValue();
        String attname = attribute.getName();
        Method meth = null;
        meth = value == null ? StandardMetaDataImpl.findSetter(mbeanClass, attname) : StandardMetaDataImpl.findSetter(mbeanClass, attname, value.getClass());
        if (meth == null && (primClass = StandardMetaDataImpl.findPrimForClass(value)) != null) {
            meth = StandardMetaDataImpl.findSetter(mbeanClass, attname, primClass);
        }
        if (meth == null) {
            meth = StandardMetaDataImpl.findSetter(mbeanClass, attname);
            if (meth == null) {
                if (StandardMetaDataImpl.isTraceOn()) {
                    StandardMetaDataImpl.trace("setAttribute", "Cannot find setter for " + attribute + " in class " + mbeanClass.getName());
                }
                throw new AttributeNotFoundException(attname + " not accessible");
            }
            Object v = attribute.getValue();
            if (v == null) {
                throw new InvalidAttributeValueException("attribute= " + attname + " value = null");
            }
            throw new InvalidAttributeValueException("attribute= " + attname + " value = " + v);
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("setAttribute", "Invoking the set method for " + attname);
        }
        Object[] values = new Object[]{value};
        try {
            result = meth.invoke(instance, values);
        }
        catch (IllegalAccessException e) {
            StandardMetaDataImpl.debugX("setAttribute", e);
            throw new ReflectionException(e, "IllegalAccessException occured trying to invoke the setter on the MBean");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            StandardMetaDataImpl.debugX("setAttribute", t);
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the MBean's setter");
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in the MBean's setter");
            }
            throw new MBeanException((Exception)t, "Exception thrown in the MBean's setter");
        }
        if (StandardMetaDataImpl.isTraceOn()) {
            StandardMetaDataImpl.trace("setAttribute", attname + "= " + value);
        }
        return value;
    }

    protected MBeanNotificationInfo[] findNotifications(Object moi) {
        if (moi instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mbn = ((NotificationBroadcaster)moi).getNotificationInfo();
            if (mbn == null) {
                return new MBeanNotificationInfo[0];
            }
            MBeanNotificationInfo[] result = new MBeanNotificationInfo[mbn.length];
            for (int i = 0; i < mbn.length; ++i) {
                result[i] = (MBeanNotificationInfo)mbn[i].clone();
            }
            return result;
        }
        return new MBeanNotificationInfo[0];
    }

    public static Method findMethod(Class classObj, String name, Class[] parameterTypes) {
        Method method = null;
        try {
            method = classObj.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class classObj, String name) {
        Method method = null;
        try {
            int i;
            Method[] methods = classObj.getMethods();
            for (i = 0; i < methods.length && !methods[i].getName().equals(name); ++i) {
            }
            if (i < methods.length) {
                method = methods[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class classObj, String name, int paramCount) {
        Method method = null;
        try {
            int i;
            Method[] methods = classObj.getMethods();
            boolean found = false;
            for (i = 0; i < methods.length && !found; ++i) {
                found = methods[i].getName().equals(name);
                if (!found) continue;
                found = methods[i].getParameterTypes().length == paramCount;
            }
            if (found) {
                method = methods[i - 1];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return method;
    }

    public static Method findGetter(Class classObj, String attribute) {
        Method m = StandardMetaDataImpl.findMethod(classObj, "get" + attribute, null);
        if (m == null) {
            m = StandardMetaDataImpl.findMethod(classObj, "is" + attribute, null);
        }
        return m;
    }

    public static Method findSetter(Class classObj, String attribute, Class type) {
        Class<?>[] pars;
        Method mth = StandardMetaDataImpl.findMethod(classObj, "set" + attribute, 1);
        if (mth != null && (pars = mth.getParameterTypes())[0].isAssignableFrom(type)) {
            return mth;
        }
        return null;
    }

    public static Method findSetter(Class classObj, String attribute) {
        return StandardMetaDataImpl.findMethod(classObj, "set" + attribute, 1);
    }

    public static Constructor findConstructor(Class theClass, Class[] parameterTypes) {
        Constructor mth = null;
        try {
            mth = theClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
        return mth;
    }

    public static Class findClassForPrim(String primName) {
        return (Class)primitiveClasses.get(primName);
    }

    public static Class findPrimForClass(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (value instanceof Character) {
            return Character.TYPE;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Long) {
            return Long.TYPE;
        }
        if (value instanceof Float) {
            return Float.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    static String[] findSignatures(Class[] clz) {
        String[] signers = new String[clz.length];
        for (int i = 0; i < clz.length; ++i) {
            signers[i] = StandardMetaDataImpl.findSignature(clz[i]);
        }
        return signers;
    }

    static String findSignature(Class clz) {
        return clz.getName();
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        StandardMetaDataImpl.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        StandardMetaDataImpl.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (StandardMetaDataImpl.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            StandardMetaDataImpl.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            StandardMetaDataImpl.debug(dbgTag, func, stack);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

