/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class RepositorySupport
implements Repository {
    private static final ObjectName _WholeWordQueryObjectName;
    private static int _slen;
    private static int _plen;
    private final Hashtable domainTb = new Hashtable(5);
    private int nbElements = 0;
    private final String domain;
    private static final String dbgTag = "Repository";

    private static final boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static final void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static final void trace(String func, String info) {
        RepositorySupport.trace(dbgTag, func, info);
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static final void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static final void debug(String func, String info) {
        RepositorySupport.debug(dbgTag, func, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addAllMatching(Hashtable moiTb, Set result, ObjectNamePattern pattern) {
        Hashtable hashtable = moiTb;
        synchronized (hashtable) {
            Enumeration e = moiTb.elements();
            while (e.hasMoreElements()) {
                NamedObject no = (NamedObject)e.nextElement();
                ObjectName on = no.getName();
                if (!pattern.matchKeys(on)) continue;
                result.add(no);
            }
        }
    }

    private final void addNewDomMoi(Object object, String dom, ObjectName name) {
        Hashtable<String, NamedObject> moiTb = new Hashtable<String, NamedObject>();
        this.domainTb.put(dom, moiTb);
        moiTb.put(name.getCanonicalKeyPropertyListString(), new NamedObject(name, object));
        ++this.nbElements;
    }

    private static boolean wildmatch(char[] s, char[] p, int si, int pi) {
        _slen = s.length;
        _plen = p.length;
        while (pi < _plen) {
            char c;
            if ((c = p[pi++]) == '?') {
                if (++si <= _slen) continue;
                return false;
            }
            if (c == '*') {
                if (pi >= _plen) {
                    return true;
                }
                do {
                    if (!RepositorySupport.wildmatch(s, p, si, pi)) continue;
                    return true;
                } while (++si < _slen);
                return false;
            }
            if (si < _slen && c == s[si++]) continue;
            return false;
        }
        return si == _slen;
    }

    private NamedObject retrieveNamedObject(ObjectName name) {
        Object tmp_object;
        if (name.isPattern()) {
            return null;
        }
        String dom = name.getDomain().intern();
        if (dom.length() == 0) {
            dom = this.domain;
        }
        if ((tmp_object = this.domainTb.get(dom)) == null) {
            return null;
        }
        Hashtable moiTb = (Hashtable)tmp_object;
        Object o = moiTb.get(name.getCanonicalKeyPropertyListString());
        if (o != null) {
            return (NamedObject)o;
        }
        return null;
    }

    public RepositorySupport(String domain) {
        this.domain = domain != null && domain.length() != 0 ? domain : "DefaultDomain";
        this.domainTb.put(this.domain.intern(), new Hashtable());
    }

    public void setConfigParameters(ArrayList configParameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        ArrayList<String> result;
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            result = new ArrayList<String>(this.domainTb.size());
            Enumeration e = this.domainTb.keys();
            while (e.hasMoreElements()) {
                Hashtable t;
                String key = (String)e.nextElement();
                if (key == null || (t = (Hashtable)this.domainTb.get(key)) == null || t.size() == 0) continue;
                result.add(key);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean isFiltering() {
        return false;
    }

    public void addMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException {
        boolean to_default_domain;
        String dom;
        block10: {
            if (RepositorySupport.isTraceOn()) {
                RepositorySupport.trace("addMBean", "name=" + name);
            }
            dom = name.getDomain().intern();
            to_default_domain = false;
            if (dom.length() == 0) {
                try {
                    name = new ObjectName(this.domain + name.toString());
                }
                catch (MalformedObjectNameException e) {
                    if (!RepositorySupport.isDebugOn()) break block10;
                    RepositorySupport.debug("addMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        if (dom == this.domain) {
            to_default_domain = true;
            dom = this.domain;
        } else {
            to_default_domain = false;
        }
        if (name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: cannot add mbean for pattern name " + name.toString()));
        }
        if (!to_default_domain && dom.equals("JMImplementation") && this.domainTb.containsKey("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
        }
        Hashtable moiTb = (Hashtable)this.domainTb.get(dom);
        if (moiTb == null) {
            this.addNewDomMoi(object, dom, name);
            return;
        }
        String cstr = name.getCanonicalKeyPropertyListString();
        Object elmt = moiTb.get(cstr);
        if (elmt != null) {
            throw new InstanceAlreadyExistsException(name.toString());
        }
        ++this.nbElements;
        moiTb.put(cstr, new NamedObject(name, object));
    }

    public boolean contains(ObjectName name) {
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("contains", "name=" + name);
        }
        return this.retrieveNamedObject(name) != null;
    }

    public Object retrieve(ObjectName name) {
        NamedObject no;
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("retrieve", "name=" + name);
        }
        if ((no = this.retrieveNamedObject(name)) == null) {
            return null;
        }
        return no.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set query(ObjectName pattern, QueryExp query) {
        ObjectNamePattern on_pattern = null;
        HashSet<NamedObject> result = new HashSet<NamedObject>();
        ObjectName name = null;
        name = pattern == null || pattern.getCanonicalName().length() == 0 || pattern.equals(_WholeWordQueryObjectName) ? _WholeWordQueryObjectName : pattern;
        if (!name.isPattern()) {
            NamedObject no = this.retrieveNamedObject(name);
            if (no != null) {
                result.add(no);
            }
            return result;
        }
        if (name == _WholeWordQueryObjectName) {
            Hashtable no = this.domainTb;
            synchronized (no) {
                Enumeration e = this.domainTb.elements();
                while (e.hasMoreElements()) {
                    Hashtable moiTb = (Hashtable)e.nextElement();
                    result.addAll(moiTb.values());
                }
            }
            return result;
        }
        String canonical_key_property_list_string = name.getCanonicalKeyPropertyListString();
        if (name.getDomain().length() == 0) {
            Hashtable moiTb = (Hashtable)this.domainTb.get(this.domain);
            if (canonical_key_property_list_string.length() == 0) {
                result.addAll(moiTb.values());
            } else {
                if (on_pattern == null) {
                    on_pattern = new ObjectNamePattern(name);
                }
                this.addAllMatching(moiTb, result, on_pattern);
            }
            return result;
        }
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            char[] dom2Match = name.getDomain().toCharArray();
            Enumeration enumi = this.domainTb.keys();
            while (enumi.hasMoreElements()) {
                String nextDomain = (String)enumi.nextElement();
                char[] theDom = nextDomain.toCharArray();
                if (!RepositorySupport.wildmatch(theDom, dom2Match, 0, 0)) continue;
                Hashtable moiTb = (Hashtable)this.domainTb.get(nextDomain);
                if (canonical_key_property_list_string.length() == 0) {
                    result.addAll(moiTb.values());
                    continue;
                }
                if (on_pattern == null) {
                    on_pattern = new ObjectNamePattern(name);
                }
                this.addAllMatching(moiTb, result, on_pattern);
            }
        }
        return result;
    }

    public void remove(ObjectName name) throws InstanceNotFoundException {
        Object tmp_object;
        String dom;
        if (RepositorySupport.isTraceOn()) {
            RepositorySupport.trace("remove", "name=" + name);
        }
        if ((dom = name.getDomain().intern()).length() == 0) {
            dom = this.domain;
        }
        if ((tmp_object = this.domainTb.get(dom)) == null) {
            throw new InstanceNotFoundException(name.toString());
        }
        Hashtable moiTb = (Hashtable)tmp_object;
        if (moiTb.remove(name.getCanonicalKeyPropertyListString()) == null) {
            throw new InstanceNotFoundException(name.toString());
        }
        --this.nbElements;
        if (moiTb.isEmpty()) {
            this.domainTb.remove(dom);
            if (dom == this.domain) {
                this.domainTb.put(this.domain, new Hashtable());
            }
        }
    }

    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    static {
        try {
            _WholeWordQueryObjectName = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    private static final class ObjectNamePattern {
        private final char[] domain;
        private final String[] keys;
        private final String[] values;
        private final String properties;
        private final boolean isPropertyPattern;
        public final ObjectName pattern;

        public ObjectNamePattern(ObjectName pattern) {
            this(pattern.isPattern(), pattern.getDomain(), pattern.isPropertyPattern(), pattern.getCanonicalKeyPropertyListString(), pattern.getKeyPropertyList(), pattern);
        }

        ObjectNamePattern(boolean domainPattern, String domain, boolean propertyPattern, String canonicalProps, Hashtable keyPropertyList, ObjectName pattern) {
            int len = keyPropertyList == null ? 0 : keyPropertyList.size();
            Enumeration e = keyPropertyList == null ? null : keyPropertyList.keys();
            this.domain = domain == null ? null : domain.toCharArray();
            this.keys = new String[len];
            this.values = new String[len];
            for (int i = 0; i < len; ++i) {
                String k;
                this.keys[i] = k = (String)e.nextElement();
                this.values[i] = (String)keyPropertyList.get(k);
            }
            this.properties = canonicalProps;
            this.isPropertyPattern = propertyPattern;
            this.pattern = pattern;
        }

        public boolean matchKeys(ObjectName name) {
            if (this.isPropertyPattern) {
                for (int i = this.keys.length - 1; i >= 0; --i) {
                    String v = name.getKeyProperty(this.keys[i]);
                    if (v == null) {
                        return false;
                    }
                    if (v.equals(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            if (this.keys.length != name.getKeyPropertyList().size()) {
                return false;
            }
            String p1 = name.getCanonicalKeyPropertyListString();
            String p2 = this.properties;
            return p1.equals(p2);
        }
    }
}

