/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationSource;

public class DOMImplementationRegistry {
    public static String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static Vector sources = new Vector();
    private static boolean initialized = false;

    private static void initialize() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        initialized = true;
        String p = System.getProperty(PROPERTY);
        if (p == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(p);
        while (st.hasMoreTokens()) {
            Object source = Class.forName(st.nextToken()).newInstance();
            sources.addElement(source);
        }
    }

    public static DOMImplementation getDOMImplementation(String features) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        int len = sources.size();
        int i = 0;
        while (i < len) {
            DOMImplementationSource source = (DOMImplementationSource)sources.elementAt(i);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl != null) {
                return impl;
            }
            ++i;
        }
        return null;
    }

    public static void addSource(DOMImplementationSource s) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        sources.addElement(s);
        StringBuffer b = new StringBuffer(System.getProperty(PROPERTY));
        b.append(" " + s.getClass().getName());
        System.setProperty(PROPERTY, b.toString());
    }
}

