/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarPreparser {
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Hashtable KNOWN_LOADERS = new Hashtable();
    protected static final String[] RECOGNIZED_PROPERTIES;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected XMLGrammarPool fGrammarPool;
    protected Locale fLocale;
    private Hashtable fLoaders;

    public XMLGrammarPreparser() {
        this(new SymbolTable());
    }

    public XMLGrammarPreparser(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fLoaders = new Hashtable();
        this.setLocale(Locale.getDefault());
        this.fErrorReporter = new XMLErrorReporter();
        this.fErrorReporter.setLocale(this.fLocale);
        this.fEntityResolver = new XMLEntityManager();
    }

    public boolean registerPreparser(String grammarType, XMLGrammarLoader loader) {
        if (loader == null) {
            if (KNOWN_LOADERS.containsKey(grammarType)) {
                String loaderName = (String)KNOWN_LOADERS.get(grammarType);
                try {
                    ClassLoader cl = ObjectFactory.findClassLoader();
                    XMLGrammarLoader gl = (XMLGrammarLoader)ObjectFactory.newInstance(loaderName, cl);
                    this.fLoaders.put(grammarType, gl);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            return false;
        }
        this.fLoaders.put(grammarType, loader);
        return true;
    }

    public Grammar preparseGrammar(String type, XMLInputSource is) throws XNIException, IOException {
        if (this.fLoaders.containsKey(type)) {
            XMLGrammarLoader gl = (XMLGrammarLoader)this.fLoaders.get(type);
            gl.setProperty(SYMBOL_TABLE, this.fSymbolTable);
            gl.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
            gl.setProperty(ERROR_REPORTER, this.fErrorReporter);
            if (this.fGrammarPool != null) {
                try {
                    gl.setProperty(GRAMMAR_POOL, this.fGrammarPool);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return gl.loadGrammar(is);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, errorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setGrammarPool(XMLGrammarPool grammarPool) {
        this.fGrammarPool = grammarPool;
    }

    public XMLGrammarPool getGrammarPool() {
        return this.fGrammarPool;
    }

    public XMLGrammarLoader getLoader(String type) {
        return (XMLGrammarLoader)this.fLoaders.get(type);
    }

    public void setFeature(String featureId, boolean value) {
        Enumeration keys = this.fLoaders.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            XMLGrammarLoader gl = (XMLGrammarLoader)this.fLoaders.get(key);
            try {
                gl.setFeature(featureId, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void setProperty(String propId, Object value) {
        Enumeration keys = this.fLoaders.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            XMLGrammarLoader gl = (XMLGrammarLoader)this.fLoaders.get(key);
            try {
                gl.setProperty(propId, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean getFeature(String type, String featureId) {
        XMLGrammarLoader gl = (XMLGrammarLoader)this.fLoaders.get(type);
        return gl.getFeature(featureId);
    }

    public Object getProperty(String type, String propertyId) {
        XMLGrammarLoader gl = (XMLGrammarLoader)this.fLoaders.get(type);
        return gl.getProperty(propertyId);
    }

    static {
        KNOWN_LOADERS.put("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.impl.xs.XMLSchemaLoader");
        KNOWN_LOADERS.put("http://www.w3.org/TR/REC-xml", "org.apache.xerces.impl.dtd.XMLDTDLoader");
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ERROR_HANDLER, ENTITY_RESOLVER, GRAMMAR_POOL};
    }
}

