/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XSDocumentInfo {
    protected SchemaNamespaceSupport fNamespaceSupport;
    protected SchemaNamespaceSupport fNamespaceSupportRoot;
    protected Stack SchemaNamespaceSupportStack = new Stack();
    protected boolean fAreLocalAttributesQualified;
    protected boolean fAreLocalElementsQualified;
    protected short fBlockDefault;
    protected short fFinalDefault;
    protected String fTargetNamespace;
    protected boolean fIsChameleonSchema;
    protected Document fSchemaDoc;
    Vector fImportedNS = new Vector();
    protected ValidationState fValidationContext = new ValidationState();
    SymbolTable fSymbolTable = null;
    private Vector fReportedTNS = null;

    XSDocumentInfo(Document schemaDoc, XSAttributeChecker attrChecker, SymbolTable symbolTable) throws XMLSchemaException {
        this.fSchemaDoc = schemaDoc;
        this.fNamespaceSupport = new SchemaNamespaceSupport();
        this.fIsChameleonSchema = false;
        this.fSymbolTable = symbolTable;
        this.fNamespaceSupport.declarePrefix(symbolTable.addSymbol("xml"), symbolTable.addSymbol("http://www.w3.org/XML/1998/namespace"));
        if (schemaDoc != null) {
            Element root = DOMUtil.getRoot(schemaDoc);
            Object[] schemaAttrs = attrChecker.checkAttributes(root, true, this);
            if (schemaAttrs == null) {
                throw new XMLSchemaException(null, null);
            }
            this.fAreLocalAttributesQualified = ((XInt)schemaAttrs[XSAttributeChecker.ATTIDX_AFORMDEFAULT]).intValue() == 1;
            this.fAreLocalElementsQualified = ((XInt)schemaAttrs[XSAttributeChecker.ATTIDX_EFORMDEFAULT]).intValue() == 1;
            this.fBlockDefault = ((XInt)schemaAttrs[XSAttributeChecker.ATTIDX_BLOCKDEFAULT]).shortValue();
            this.fFinalDefault = ((XInt)schemaAttrs[XSAttributeChecker.ATTIDX_FINALDEFAULT]).shortValue();
            this.fTargetNamespace = (String)schemaAttrs[XSAttributeChecker.ATTIDX_TARGETNAMESPACE];
            if (this.fTargetNamespace != null) {
                this.fTargetNamespace = symbolTable.addSymbol(this.fTargetNamespace);
            }
            this.fNamespaceSupportRoot = new SchemaNamespaceSupport(this.fNamespaceSupport);
            this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
            this.fValidationContext.setSymbolTable(symbolTable);
            attrChecker.returnAttrArray(schemaAttrs, null);
        }
    }

    void backupNSSupport(SchemaNamespaceSupport nsSupport) {
        this.SchemaNamespaceSupportStack.push(this.fNamespaceSupport);
        if (nsSupport == null) {
            nsSupport = this.fNamespaceSupportRoot;
        }
        this.fNamespaceSupport = new SchemaNamespaceSupport(nsSupport);
        this.fNamespaceSupport.declarePrefix(this.fSymbolTable.addSymbol("xml"), this.fSymbolTable.addSymbol("http://www.w3.org/XML/1998/namespace"));
        this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
    }

    void restoreNSSupport() {
        this.fNamespaceSupport = (SchemaNamespaceSupport)this.SchemaNamespaceSupportStack.pop();
        this.fValidationContext.setNamespaceSupport(this.fNamespaceSupport);
    }

    public String toString() {
        return this.fTargetNamespace == null ? "no targetNamspace" : "targetNamespace is " + this.fTargetNamespace;
    }

    public void addAllowedNS(String namespace) {
        this.fImportedNS.addElement(namespace == null ? "" : namespace);
    }

    public boolean isAllowedNS(String namespace) {
        return this.fImportedNS.contains(namespace == null ? "" : namespace);
    }

    final boolean needReportTNSError(String uri) {
        if (this.fReportedTNS == null) {
            this.fReportedTNS = new Vector();
        } else if (this.fReportedTNS.contains(uri)) {
            return false;
        }
        this.fReportedTNS.addElement(uri);
        return true;
    }
}

