/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private final SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDSimpleTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
        if (this.schemaFactory instanceof SchemaDVFactoryImpl) {
            ((SchemaDVFactoryImpl)this.schemaFactory).setDeclPool(handler.fDeclPool);
        }
    }

    XSSimpleType traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (nameAtt == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ATT_NAME}, elmNode);
            type = null;
        }
        if (type != null) {
            grammar.addGlobalTypeDecl(type);
        }
        return type;
    }

    XSSimpleType traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    private XSSimpleType traverseSimpleTypeDecl(Element simpleTypeDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        XSObjectList dvs;
        String name = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XInt finalAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        int finalProperty = finalAttr == null ? schemaDoc.fFinalDefault : finalAttr.intValue();
        Element child = DOMUtil.getFirstChildElement(simpleTypeDecl);
        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, simpleTypeDecl);
            return this.errorType(name, schemaDoc.fTargetNamespace, (short)2);
        }
        String varietyProperty = DOMUtil.getLocalName(child);
        short refType = 2;
        boolean restriction = false;
        boolean list = false;
        boolean union = false;
        if (varietyProperty.equals(SchemaSymbols.ELT_RESTRICTION)) {
            refType = 2;
            restriction = true;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_LIST)) {
            refType = 16;
            list = true;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_UNION)) {
            refType = 8;
            union = true;
        } else {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, simpleTypeDecl);
            return this.errorType(name, schemaDoc.fTargetNamespace, (short)2);
        }
        Element nextChild = DOMUtil.getNextSiblingElement(child);
        if (nextChild != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, nextChild);
        }
        Object[] contentAttrs = this.fAttrChecker.checkAttributes(child, false, schemaDoc);
        QName baseTypeName = (QName)contentAttrs[restriction ? XSAttributeChecker.ATTIDX_BASE : XSAttributeChecker.ATTIDX_ITEMTYPE];
        Vector memberTypes = (Vector)contentAttrs[XSAttributeChecker.ATTIDX_MEMBERTYPES];
        Element content = DOMUtil.getFirstChildElement(child);
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(content, contentAttrs, false, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        XSSimpleType baseValidator = null;
        if ((restriction || list) && baseTypeName != null) {
            baseValidator = this.findDTValidator(child, baseTypeName, refType, schemaDoc);
        }
        Vector<XSObject> dTValidators = null;
        XSSimpleType dv = null;
        if (union && memberTypes != null && memberTypes.size() > 0) {
            int size = memberTypes.size();
            dTValidators = new Vector<XSObject>(size, 2);
            int i = 0;
            while (i < size) {
                dv = this.findDTValidator(child, (QName)memberTypes.elementAt(i), (short)8, schemaDoc);
                if (dv != null) {
                    if (dv.getVariety() == 3) {
                        dvs = dv.getMemberTypes();
                        int j = 0;
                        while (j < dvs.getLength()) {
                            dTValidators.addElement(dvs.getItem(j));
                            ++j;
                        }
                    } else {
                        dTValidators.addElement(dv);
                    }
                }
                ++i;
            }
        }
        boolean skipFacets = false;
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            if (restriction || list) {
                if (baseTypeName != null) {
                    this.reportSchemaError(list ? "src-simple-type.3" : "src-simple-type.2", null, content);
                } else {
                    baseValidator = this.traverseLocal(content, schemaDoc, grammar);
                }
                content = DOMUtil.getNextSiblingElement(content);
            } else if (union) {
                if (dTValidators == null) {
                    dTValidators = new Vector(2, 2);
                }
                do {
                    if ((dv = this.traverseLocal(content, schemaDoc, grammar)) == null) continue;
                    if (dv.getVariety() == 3) {
                        dvs = dv.getMemberTypes();
                        int j = 0;
                        while (j < dvs.getLength()) {
                            dTValidators.addElement(dvs.getItem(j));
                            ++j;
                        }
                    } else {
                        dTValidators.addElement(dv);
                    }
                } while ((content = DOMUtil.getNextSiblingElement(content)) != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE));
            }
        } else if ((restriction || list) && baseTypeName == null) {
            this.reportSchemaError("src-simple-type.2", null, child);
            skipFacets = true;
            baseValidator = SchemaGrammar.fAnySimpleType;
        } else if (union && (memberTypes == null || memberTypes.size() == 0)) {
            this.reportSchemaError("src-union-memberTypes-or-simpleTypes", null, child);
            dTValidators = new Vector(1);
            dTValidators.addElement(SchemaGrammar.fAnySimpleType);
        }
        if ((restriction || list) && baseValidator == null) {
            baseValidator = SchemaGrammar.fAnySimpleType;
        }
        if (union && (dTValidators == null || dTValidators.size() == 0)) {
            dTValidators = new Vector(1);
            dTValidators.addElement(SchemaGrammar.fAnySimpleType);
        }
        if (list && this.isListDatatype(baseValidator)) {
            this.reportSchemaError("cos-list-of-atomic", new Object[]{name}, child);
        }
        XSSimpleType newDecl = null;
        if (restriction) {
            newDecl = this.schemaFactory.createTypeRestriction(name, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator);
        } else if (list) {
            newDecl = this.schemaFactory.createTypeList(name, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator);
        } else if (union) {
            XSSimpleType[] memberDecls = new XSSimpleType[dTValidators.size()];
            int i = 0;
            while (i < dTValidators.size()) {
                memberDecls[i] = (XSSimpleType)dTValidators.elementAt(i);
                ++i;
            }
            newDecl = this.schemaFactory.createTypeUnion(name, schemaDoc.fTargetNamespace, (short)finalProperty, memberDecls);
        }
        if (restriction && content != null) {
            XSDAbstractTraverser.FacetInfo fi = this.traverseFacets(content, baseValidator, schemaDoc);
            content = fi.nodeAfterFacets;
            if (!skipFacets) {
                try {
                    this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                    newDecl.applyFacets(fi.facetdata, fi.fPresentFacets, fi.fFixedFacets, this.fValidationState);
                }
                catch (InvalidDatatypeFacetException ex) {
                    this.reportSchemaError(ex.getKey(), ex.getArgs(), child);
                }
            }
        }
        if (content != null) {
            if (restriction) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))"}, content);
            } else if (list) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))"}, content);
            } else if (union) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType*))"}, content);
            }
        }
        this.fAttrChecker.returnAttrArray(contentAttrs, schemaDoc);
        return newDecl;
    }

    private XSSimpleType findDTValidator(Element elm, QName baseTypeStr, short baseRefContext, XSDocumentInfo schemaDoc) {
        if (baseTypeStr == null) {
            return null;
        }
        XSTypeDecl baseType = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeStr, elm);
        if (baseType != null) {
            if (baseType.getTypeCategory() != 14 || baseType == SchemaGrammar.fAnySimpleType && baseRefContext == 2) {
                this.reportSchemaError("st-props-correct.4.1", new Object[]{baseTypeStr.rawname}, elm);
                return SchemaGrammar.fAnySimpleType;
            }
            if ((baseType.getFinal() & baseRefContext) != 0) {
                if (baseRefContext == 2) {
                    this.reportSchemaError("st-props-correct.3", new Object[]{baseTypeStr.rawname}, elm);
                } else if (baseRefContext == 16) {
                    this.reportSchemaError("st-props-correct.4.2.1", new Object[]{baseTypeStr.rawname}, elm);
                } else if (baseRefContext == 8) {
                    this.reportSchemaError("st-props-correct.4.2.2", new Object[]{baseTypeStr.rawname}, elm);
                }
            }
        }
        return (XSSimpleType)baseType;
    }

    private boolean isListDatatype(XSSimpleType validator) {
        if (validator.getVariety() == 2) {
            return true;
        }
        if (validator.getVariety() == 3) {
            XSObjectList temp = validator.getMemberTypes();
            int i = 0;
            while (i < temp.getLength()) {
                if (((XSSimpleType)temp.getItem(i)).getVariety() == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private XSSimpleType errorType(String name, String namespace, short refType) {
        switch (refType) {
            case 2: {
                return this.schemaFactory.createTypeRestriction(name, namespace, (short)0, SchemaGrammar.fAnySimpleType);
            }
            case 16: {
                return this.schemaFactory.createTypeList(name, namespace, (short)0, SchemaGrammar.fAnySimpleType);
            }
            case 8: {
                return this.schemaFactory.createTypeUnion(name, namespace, (short)0, new XSSimpleType[]{SchemaGrammar.fAnySimpleType});
            }
        }
        return null;
    }
}

