/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    private XPath.LocationPath[] fLocationPaths;
    private boolean fShouldBufferContent;
    private boolean fBufferContent;
    private StringBuffer fMatchedBuffer = new StringBuffer();
    private boolean[] fMatched;
    private String fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    protected SymbolTable fSymbolTable;
    protected IdentityConstraint fIDConstraint;

    public XPathMatcher(XPath xpath) {
        this(xpath, false, null);
    }

    public XPathMatcher(XPath xpath, boolean shouldBufferContent, IdentityConstraint idConstraint) {
        this.fLocationPaths = xpath.getLocationPaths();
        this.fShouldBufferContent = shouldBufferContent;
        this.fIDConstraint = idConstraint;
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        int i = 0;
        while (i < this.fStepIndexes.length) {
            this.fStepIndexes[i] = new IntStack();
            ++i;
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new boolean[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            if (this.fMatched[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getIsSelector() {
        return this.fIDConstraint == null;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIDConstraint;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void matched(String content, XSSimpleType val, boolean isNil) throws XNIException {
    }

    public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
        this.clear();
        int i = 0;
        while (i < this.fLocationPaths.length) {
            this.fStepIndexes[i].clear();
            this.fCurrentStep[i] = 0;
            this.fNoMatchDepth[i] = 0;
            this.fMatched[i] = false;
            ++i;
        }
        this.fSymbolTable = symbolTable;
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(QName element, XMLAttributes attributes, XSElementDecl elementDecl) throws XNIException {
        i = 0;
        while (i < this.fLocationPaths.length) {
            block24: {
                block26: {
                    block25: {
                        block23: {
                            startStep = this.fCurrentStep[i];
                            this.fStepIndexes[i].push(startStep);
                            if (!this.fMatched[i] && this.fNoMatchDepth[i] <= 0) break block23;
                            v0 = i;
                            this.fNoMatchDepth[v0] = this.fNoMatchDepth[v0] + 1;
                            break block24;
                        }
                        steps = this.fLocationPaths[i].steps;
                        while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 3) {
                            v1 = i;
                            this.fCurrentStep[v1] = this.fCurrentStep[v1] + 1;
                        }
                        if (this.fCurrentStep[i] != steps.length) break block25;
                        this.fMatched[i] = true;
                        j = 0;
                        while (j < i && !this.fMatched[j]) {
                            ++j;
                        }
                        if (j == i) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                        break block24;
                    }
                    descendantStep = this.fCurrentStep[i];
                    while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 4) {
                        v2 = i;
                        this.fCurrentStep[v2] = this.fCurrentStep[v2] + 1;
                    }
                    if (this.fCurrentStep[i] != steps.length) break block26;
                    v3 = i;
                    this.fNoMatchDepth[v3] = this.fNoMatchDepth[v3] + 1;
                    break block24;
                }
                if (this.fCurrentStep[i] != startStep && this.fCurrentStep[i] <= descendantStep || steps[this.fCurrentStep[i]].axis.type != 1) ** GOTO lbl47
                step = steps[this.fCurrentStep[i]];
                nodeTest = step.nodeTest;
                if (nodeTest.type == 1 && !nodeTest.name.equals(element)) {
                    if (this.fCurrentStep[i] > descendantStep) {
                        this.fCurrentStep[i] = descendantStep;
                    } else {
                        v4 = i;
                        this.fNoMatchDepth[v4] = this.fNoMatchDepth[v4] + 1;
                    }
                } else {
                    v5 = i;
                    this.fCurrentStep[v5] = this.fCurrentStep[v5] + 1;
lbl47:
                    // 2 sources

                    if (this.fCurrentStep[i] == steps.length) {
                        this.fMatched[i] = true;
                        j = 0;
                        while (j < i && !this.fMatched[j]) {
                            ++j;
                        }
                        if (j == i) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                    } else if (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 2) {
                        attrCount = attributes.getLength();
                        if (attrCount > 0) {
                            nodeTest = steps[this.fCurrentStep[i]].nodeTest;
                            aname = new QName();
                            attrGrp = null;
                            if (elementDecl != null && (type = elementDecl.fType) != null && type.getTypeCategory() == 13) {
                                ctype = (XSComplexTypeDecl)type;
                                attrGrp = ctype.fAttrGrp;
                            }
                            aindex = 0;
                            while (aindex < attrCount) {
                                attributes.getName(aindex, aname);
                                if (nodeTest.type != 1 || nodeTest.name.equals(aname)) {
                                    v6 = i;
                                    this.fCurrentStep[v6] = this.fCurrentStep[v6] + 1;
                                    if (this.fCurrentStep[i] != steps.length) break;
                                    this.fMatched[i] = true;
                                    j = 0;
                                    while (j < i && !this.fMatched[j]) {
                                        ++j;
                                    }
                                    if (j != i) break;
                                    this.fMatchedString = avalue = attributes.getValue(aindex);
                                    aValidator = null;
                                    if (attrGrp != null && (tempAttUse = attrGrp.getAttributeUse(aname.uri, aname.localpart)) != null) {
                                        tempAttDecl = tempAttUse.fAttrDecl;
                                        aValidator = tempAttDecl.fType;
                                    }
                                    this.matched(this.fMatchedString, aValidator, false);
                                    break;
                                }
                                ++aindex;
                            }
                        }
                        if (!this.fMatched[i]) {
                            if (this.fCurrentStep[i] > descendantStep) {
                                this.fCurrentStep[i] = descendantStep;
                            } else {
                                v7 = i;
                                this.fNoMatchDepth[v7] = this.fNoMatchDepth[v7] + 1;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void characters(XMLString text) throws XNIException {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            if (this.fBufferContent && this.fNoMatchDepth[i] == 0) {
                this.fMatchedBuffer.append(text);
                break;
            }
            ++i;
        }
    }

    public void endElement(QName element, XSElementDecl eDecl) {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            block13: {
                block12: {
                    block11: {
                        if (this.fNoMatchDepth[i] <= 0) break block11;
                        int n = i;
                        this.fNoMatchDepth[n] = this.fNoMatchDepth[n] - 1;
                        break block12;
                    }
                    int j = 0;
                    while (j < i && !this.fMatched[j]) {
                        ++j;
                    }
                    if (j < i) break block13;
                    if (this.fBufferContent) {
                        XSTypeDecl type;
                        this.fBufferContent = false;
                        this.fMatchedString = this.fMatchedBuffer.toString();
                        XSSimpleType val = null;
                        if (eDecl != null && (type = eDecl.fType) != null) {
                            if (type.getTypeCategory() == 13) {
                                XSComplexTypeDecl ctype = (XSComplexTypeDecl)type;
                                val = ctype.fXSSimpleType;
                            } else {
                                val = (XSSimpleType)type;
                            }
                        }
                        if (eDecl != null) {
                            this.matched(this.fMatchedString, val, eDecl.getIsNillable());
                        } else {
                            this.matched(this.fMatchedString, val, false);
                        }
                    }
                    this.clear();
                }
                this.fCurrentStep[i] = this.fStepIndexes[i].pop();
            }
            ++i;
        }
    }

    public void endDocumentFragment() throws XNIException {
        this.clear();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        String s = super.toString();
        int index2 = s.lastIndexOf(46);
        if (index2 != -1) {
            s = s.substring(index2 + 1);
        }
        str.append(s);
        int i = 0;
        while (i < this.fLocationPaths.length) {
            str.append('[');
            XPath.Step[] steps = this.fLocationPaths[i].steps;
            int j = 0;
            while (j < steps.length) {
                if (j == this.fCurrentStep[i]) {
                    str.append('^');
                }
                str.append(steps[i].toString());
                if (j < steps.length - 1) {
                    str.append('/');
                }
                ++j;
            }
            if (this.fCurrentStep[i] == steps.length) {
                str.append('^');
            }
            str.append(']');
            str.append(',');
            ++i;
        }
        return str.toString();
    }

    private void clear() {
        this.fBufferContent = false;
        this.fMatchedBuffer.setLength(0);
        this.fMatchedString = null;
        int i = 0;
        while (i < this.fLocationPaths.length) {
            this.fMatched[i] = false;
            ++i;
        }
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    str.append("\\n");
                    break;
                }
                default: {
                    str.append(c);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

