/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RMIIIOPServerImpl
extends RMIServerImpl {
    private final Map env;

    public RMIIIOPServerImpl(Map env) throws IOException {
        super(env);
        this.env = env == null ? Collections.EMPTY_MAP : env;
    }

    protected void export() throws IOException {
        PortableRemoteObject.exportObject((Remote)this);
    }

    protected String getProtocol() {
        return "iiop";
    }

    public Remote toStub() throws IOException {
        Remote stub = PortableRemoteObject.toStub((Remote)this);
        return stub;
    }

    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.env);
        PortableRemoteObject.exportObject((Remote)client);
        return client;
    }

    protected void closeClient(RMIConnection client) throws IOException {
        PortableRemoteObject.unexportObject((Remote)client);
    }

    protected void closeServer() throws IOException {
        PortableRemoteObject.unexportObject((Remote)this);
    }
}

