/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;

public abstract class JMXConnectorServer
extends NotificationBroadcasterSupport
implements JMXConnectorServerMBean,
MBeanRegistration {
    public static final String AUTHENTICATOR = "jmx.remote.authenticator";
    private MBeanServer mbeanServer = null;
    private ObjectName myName;
    private final int[] lock = new int[0];
    private List connectionIds = new ArrayList();
    private static final int[] sequenceNumberLock = new int[0];
    private static long sequenceNumber;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectionNotification;

    public JMXConnectorServer() {
        this((MBeanServer)null);
    }

    public JMXConnectorServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public synchronized void setMBeanServerForwarder(MBeanServerForwarder mbsf) {
        if (mbsf == null) {
            throw new IllegalArgumentException("Invalid null argument: mbsf");
        }
        if (this.mbeanServer != null) {
            mbsf.setMBeanServer(this.mbeanServer);
        }
        this.mbeanServer = mbsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionIds() {
        List list = this.connectionIds;
        synchronized (list) {
            return this.connectionIds.toArray(new String[this.connectionIds.size()]);
        }
    }

    public JMXConnector toJMXConnector(Map env) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        JMXServiceURL addr = this.getAddress();
        return JMXConnectorFactory.newJMXConnector(addr, env);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed"};
        String className = (class$javax$management$remote$JMXConnectionNotification == null ? (class$javax$management$remote$JMXConnectionNotification = JMXConnectorServer.class$("javax.management.remote.JMXConnectionNotification")) : class$javax$management$remote$JMXConnectionNotification).getName();
        String description = "A client connection has been opened or closed";
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, className, "A client connection has been opened or closed")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(String connectionId, String message, Object userData) {
        if (connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.add(connectionId);
        }
        this.sendNotification("jmx.remote.connection.opened", connectionId, message, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(String connectionId, String message, Object userData) {
        if (connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(connectionId);
        }
        this.sendNotification("jmx.remote.connection.closed", connectionId, message, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionFailed(String connectionId, String message, Object userData) {
        if (connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(connectionId);
        }
        this.sendNotification("jmx.remote.connection.failed", connectionId, message, userData);
    }

    private void sendNotification(String type, String connectionId, String message, Object userData) {
        JMXConnectionNotification notif = new JMXConnectionNotification(type, this.getNotificationSource(), connectionId, JMXConnectorServer.nextSequenceNumber(), message, userData);
        this.sendNotification(notif);
    }

    private synchronized Object getNotificationSource() {
        if (this.myName != null) {
            return this.myName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextSequenceNumber() {
        int[] nArray = sequenceNumberLock;
        synchronized (sequenceNumberLock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sequenceNumber++;
        }
    }

    public synchronized ObjectName preRegister(MBeanServer mbs, ObjectName name) {
        if (mbs == null || name == null) {
            throw new NullPointerException("Null MBeanServer or ObjectName");
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = mbs;
            this.myName = name;
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public synchronized void preDeregister() throws Exception {
        if (this.myName != null && this.isActive()) {
            this.stop();
            this.myName = null;
        }
    }

    public void postDeregister() {
        this.myName = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

