/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import com.sun.jmx.remote.util.Service;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

public class JMXConnectorFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorFactory");
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorProvider;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorFactory;

    private JMXConnectorFactory() {
    }

    public static JMXConnector connect(JMXServiceURL serviceURL) throws IOException {
        return JMXConnectorFactory.connect(serviceURL, null);
    }

    public static JMXConnector connect(JMXServiceURL serviceURL, Map environment) throws IOException {
        if (serviceURL == null) {
            throw new NullPointerException("Null JMXServiceURL");
        }
        JMXConnector conn = JMXConnectorFactory.newJMXConnector(serviceURL, environment);
        conn.connect(environment);
        return conn;
    }

    public static JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map environment) throws IOException {
        if (environment == null) {
            environment = new HashMap();
        } else {
            EnvHelp.checkAttributes(environment);
            environment = new HashMap(environment);
        }
        ClassLoader loader = JMXConnectorFactory.resolveClassLoader(environment);
        Class targetInterface = class$javax$management$remote$JMXConnectorProvider == null ? (class$javax$management$remote$JMXConnectorProvider = JMXConnectorFactory.class$("javax.management.remote.JMXConnectorProvider")) : class$javax$management$remote$JMXConnectorProvider;
        String protocol = serviceURL.getProtocol();
        String providerClassName = "ClientProvider";
        JMXConnectorProvider provider = (JMXConnectorProvider)JMXConnectorFactory.getProvider(serviceURL, environment, "ClientProvider", targetInterface, loader);
        if (provider == null) {
            JMXConnector connection;
            if (loader != null && (connection = JMXConnectorFactory.getConnectorAsService(loader, serviceURL, environment)) != null) {
                return connection;
            }
            provider = (JMXConnectorProvider)JMXConnectorFactory.getProvider(protocol, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, (class$javax$management$remote$JMXConnectorFactory == null ? (class$javax$management$remote$JMXConnectorFactory = JMXConnectorFactory.class$("javax.management.remote.JMXConnectorFactory")) : class$javax$management$remote$JMXConnectorFactory).getClassLoader(), "ClientProvider", targetInterface);
        }
        if (provider == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        environment = Collections.unmodifiableMap(environment);
        return provider.newJMXConnector(serviceURL, environment);
    }

    private static String resolvePkgs(Map env) throws JMXProviderException {
        Object pkgsObject = null;
        if (env != null) {
            pkgsObject = env.get(PROTOCOL_PROVIDER_PACKAGES);
        }
        if (pkgsObject == null) {
            pkgsObject = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES);
                }
            });
        }
        if (pkgsObject == null) {
            return null;
        }
        if (!(pkgsObject instanceof String)) {
            String msg = "Value of jmx.remote.protocol.provider.pkgs parameter is not a String: " + pkgsObject.getClass().getName();
            throw new JMXProviderException(msg);
        }
        String pkgs = (String)pkgsObject;
        if (pkgs.trim().equals("")) {
            return null;
        }
        if (pkgs.startsWith("|") || pkgs.endsWith("|") || pkgs.indexOf("||") >= 0) {
            String msg = "Value of jmx.remote.protocol.provider.pkgs contains an empty element: " + pkgs;
            throw new JMXProviderException(msg);
        }
        return pkgs;
    }

    static Object getProvider(JMXServiceURL serviceURL, Map environment, String providerClassName, Class targetInterface, ClassLoader loader) throws IOException {
        String protocol = serviceURL.getProtocol();
        String pkgs = JMXConnectorFactory.resolvePkgs(environment);
        Object instance = null;
        if (pkgs != null) {
            environment.put(PROTOCOL_PROVIDER_CLASS_LOADER, loader);
            instance = JMXConnectorFactory.getProvider(protocol, pkgs, loader, providerClassName, targetInterface);
        }
        return instance;
    }

    static Iterator getProviderIterator(final Class providerClass, final ClassLoader loader) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return Service.providers(providerClass, loader);
            }
        };
        return (Iterator)AccessController.doPrivileged(action);
    }

    private static JMXConnector getConnectorAsService(ClassLoader loader, JMXServiceURL url, Map map) throws IllegalArgumentException, JMXProviderException {
        Iterator providers = JMXConnectorFactory.getProviderIterator(class$javax$management$remote$JMXConnectorProvider == null ? (class$javax$management$remote$JMXConnectorProvider = JMXConnectorFactory.class$("javax.management.remote.JMXConnectorProvider")) : class$javax$management$remote$JMXConnectorProvider, loader);
        JMXConnectorProvider provider = null;
        JMXConnector connection = null;
        while (providers.hasNext()) {
            provider = (JMXConnectorProvider)providers.next();
            try {
                connection = provider.newJMXConnector(url, map);
                return connection;
            }
            catch (JMXProviderException e) {
                throw e;
            }
            catch (Exception e) {
                if (!logger.traceOn()) continue;
                logger.trace("getConnectorAsService", "URL[" + url + "] Service provider exception: " + e);
            }
        }
        return null;
    }

    static Object getProvider(String protocol, String pkgs, ClassLoader loader, String providerClassName, Class targetInterface) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(pkgs, "|");
        while (tokenizer.hasMoreTokens()) {
            Class<?> providerClass;
            String pkg = tokenizer.nextToken();
            String className = pkg + "." + JMXConnectorFactory.protocol2package(protocol) + "." + providerClassName;
            try {
                providerClass = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!targetInterface.isAssignableFrom(providerClass)) {
                String msg = "Provider class does not implement " + targetInterface.getName() + ": " + providerClass.getName();
                throw new JMXProviderException(msg);
            }
            try {
                return providerClass.newInstance();
            }
            catch (Exception e) {
                String msg = "Exception when instantiating provider [" + className + "]";
                throw new JMXProviderException(msg, e);
            }
        }
        return null;
    }

    static ClassLoader resolveClassLoader(Map environment) {
        ClassLoader loader = null;
        if (environment != null) {
            try {
                loader = (ClassLoader)environment.get(PROTOCOL_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException e) {
                String msg = "The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader";
                throw new IllegalArgumentException("The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader");
            }
        }
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return loader;
    }

    private static String protocol2package(String protocol) {
        return protocol.replace('+', '.').replace('-', '_');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

