package sample.form;

import jaxcent.*;
import java.util.Map;

/**
  * Jaxcent sample.
  *
  * Shipping address handler.
  * Handles the "Copy from billing address" button.
  */

public class ShippingAddress extends jaxcent.JaxcentPage {

    HtmlInputText shippingAddress = new HtmlInputText( this, SearchType.searchByName, "shippingAddress" );
    HtmlInputText shippingCity = new HtmlInputText( this, SearchType.searchByName, "shippingCity" );
    HtmlInputText shippingState = new HtmlInputText( this, SearchType.searchByName, "shippingState" );
    HtmlInputText shippingZip = new HtmlInputText( this, SearchType.searchByName, "shippingZip" );
    HtmlInputText shippingCountry = new HtmlInputText( this, SearchType.searchByName, "shippingCountry" );

    HtmlInputCheckbox copyFromBilling = new HtmlInputCheckbox( this, "copyShipping" ) {
        protected void onClick( String value )
        {
            if ( ! value.equals( "on" ))
                return;  // We are only interested in the checkbox getting checked on

            copyDataFromBilling();
        }
    };

    void copyDataFromBilling()
    {

        try {
            Map dataMap = getAllSessionData( false );

            // If user has visited the "Name and address" page, there will be a non null
            // entry for "firstName" (even if it is the empty string)

            if ( dataMap.get( "firstName" ) == null ) {
                showMessageDialog( "You have not visited the name and address page yet!" );
                copyFromBilling.setChecked( false );
                return;
            }

            String address = (String) dataMap.get( "billingAddress" );
            String city = (String) dataMap.get( "billingCity" );
            String state = (String) dataMap.get( "billingState" );
            String zip = (String) dataMap.get( "billingzip" );
            String country = (String) dataMap.get( "billingCountry" );
          
            if ( address.equals( "" ) &&
                 city.equals( "" ) &&
                 state.equals( "" ) &&
                 zip.equals( "" ) &&
                 country.equals( "" )) {
                showMessageDialog( "You have not entered any data to copy!" );
                copyFromBilling.setChecked( false );
                return;
            }

            // Copy the data.

            setBatchUpdates( true );

            shippingAddress.setValue( address );
            shippingCity.setValue( city );
            shippingState.setValue( state );
            shippingZip.setValue( zip );
            shippingCountry.setValue( country );
         } catch (Jaxception jax) {
            jax.printStackTrace();
        } finally {
            setBatchUpdates( false );
        }
    }
}
