/*
 * Decompiled with CFR 0.152.
 */
package jaxcentFramework;

import java.io.File;
import java.net.URLEncoder;
import java.util.Hashtable;
import jaxcentFramework.JaxcentConnection;
import jaxcentFramework.JaxcentContext;
import jaxcentFramework.JaxcentHttpMain;

public class JaxcentFramework {
    JaxcentHttpMain httpMain;
    static final String version = "2.0.1";
    JaxcentContext context;
    File configFile = null;
    String configError = null;
    boolean displayMessage = true;
    long keepAliveTimeout = 290000L;
    long connectionLostTimeout = 4L * this.keepAliveTimeout;
    long queryTimeout = 20000L;
    boolean refreshUrlMap = true;
    String classpath = null;
    String jsVersion = "";

    public JaxcentFramework(JaxcentHttpMain jaxcentHttpMain) {
        this.httpMain = jaxcentHttpMain;
    }

    void loadContext() {
        this.context = this.httpMain.getJaxcentContext();
        if (this.context == null) {
            this.configError = null;
            if (!this.configFile.exists()) {
                this.configError = "Jaxcent Configuration File \"" + this.configFile.getAbsolutePath() + "\" was not found.";
                return;
            }
            if (!this.configFile.canRead()) {
                this.configError = "Jaxcent Configuration File \"" + this.configFile.getAbsolutePath() + "\" is not readable.";
                return;
            }
            this.context = new JaxcentContext(this.configFile, this);
            this.configError = this.context.getConfigError();
            if (this.configError != null) {
                this.context = null;
            } else {
                this.httpMain.setJaxcentContext(this.context);
            }
        }
    }

    public void init() {
        int n;
        String string = this.httpMain.getConfigItem("DisplayServletMessage");
        if (string != null && string.equalsIgnoreCase("false")) {
            this.displayMessage = false;
        }
        if ((string = this.httpMain.getConfigItem("RefreshURLMap")) != null && string.equalsIgnoreCase("false")) {
            this.refreshUrlMap = false;
        }
        if ((string = this.httpMain.getConfigItem("KeepAliveTimeout")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n >= 1000) {
                    this.configError = "Jaxcent Configuration Error: \"KeepAliveTimeout\" cannot be larger than 1000 seconds.";
                    return;
                }
                this.keepAliveTimeout = (long)n * 1000L;
            }
            catch (Exception exception) {
                this.configError = "Jaxcent Configuration Error: \"KeepAliveTimeout\" must be an integer, found \"" + string + "\"";
                return;
            }
        }
        if ((string = this.httpMain.getConfigItem("ConnectionLostTimeout")) == null) {
            this.connectionLostTimeout = this.keepAliveTimeout * 5L;
        } else {
            try {
                n = Integer.parseInt(string);
                int n2 = (int)(this.keepAliveTimeout / 100L);
                if (n >= n2) {
                    this.configError = "Jaxcent Configuration Error: \"ConnectionLostTime\" cannot be larger than 10 x KeepAliveTimeout (= " + n2 + " seconds.)";
                    return;
                }
                this.connectionLostTimeout = (long)n * 1000L;
            }
            catch (Exception exception) {
                this.configError = "Jaxcent Configuration Error: \"ConnectionLostTimeout\" must be an integer, found \"" + string + "\"";
                return;
            }
        }
        string = this.httpMain.getConfigItem("ClientResponseTimeout");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n >= 45) {
                    this.configError = "Jaxcent Configuration Error: \"ClientResponseTimeout\" cannot be larger than 45 seconds.)";
                    return;
                }
                this.queryTimeout = (long)n * 1000L;
            }
            catch (Exception exception) {
                this.configError = "Jaxcent Configuration Error: \"ConnectionLostTimeout\" must be an integer, found \"" + string + "\"";
                return;
            }
        }
        this.classpath = this.httpMain.getConfigItem("ReloadableClasses");
        String string2 = this.httpMain.getConfigItem("JaxcentConfigXML");
        if (string2 == null) {
            this.configError = "Jaxcent Configuration Error: \"JaxcentConfigXML\" is not configured in application or servlet parameters.";
            return;
        }
        this.configFile = new File(string2);
        if (!this.configFile.exists()) {
            this.configError = "Jaxcent Configuration File \"" + this.configFile.getAbsolutePath() + "\" was not found.";
            return;
        }
        if (!this.configFile.canRead()) {
            this.configError = "Jaxcent Configuration File \"" + this.configFile.getAbsolutePath() + "\" is not readable.";
            return;
        }
        this.loadContext();
    }

    String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public String process(Object object, String string, String string2) {
        String[] stringArray;
        if (this.context != null && (this.configError != null || this.refreshUrlMap)) {
            this.configError = null;
            this.context.refresh();
        } else if (this.context == null && this.configFile != null) {
            this.configError = null;
            this.loadContext();
        }
        String string3 = this.httpMain.getRequestParameter(object, "url");
        String string4 = this.httpMain.getRequestParameter(object, "conid");
        if (this.configError != null && (string3 != null || string4 != null)) {
            return "jaxcent&0&21&" + this.encode(this.configError);
        }
        if (string3 != null) {
            this.jsVersion = this.httpMain.getRequestParameter(object, "version");
            String[] stringArray2 = new String[1];
            JaxcentConnection jaxcentConnection = this.context.newConnection(string3, string, string2, object, stringArray2);
            if (jaxcentConnection == null) {
                return "jaxcent&0&21&" + this.encode(stringArray2[0]);
            }
            return "jaxcent&" + jaxcentConnection.getId() + "&48&" + version + "&" + jaxcentConnection.getInitString();
        }
        if (string4 == null) {
            if (!this.displayMessage) {
                return null;
            }
            String string5 = "Jaxcent Servlet, Copyright (C) Desiderata Software 2008\r\n\r\n";
            if (this.configError != null) {
                string5 = string5 + "There is an error in Jaxcent servlet configuration:\r\n\r\n" + this.configError;
            } else {
                string5 = string5 + "The Jaxcent servlet is configured ok.\r\n";
                string5 = string5 + "  Reloadable Classpath: " + this.classpath + "\r\n";
                string5 = string5 + "  Configuration XML File: " + this.configFile.getAbsolutePath() + "\r\n";
                string5 = string5 + "  Refresh Configuration XML File: " + this.refreshUrlMap + "\r\n\r\n";
                StringBuffer stringBuffer = new StringBuffer();
                this.context.printUrlMap(stringBuffer);
                string5 = string5 + stringBuffer.toString();
            }
            return string5;
        }
        JaxcentConnection jaxcentConnection = this.context.getConnection(string4);
        if (jaxcentConnection == null) {
            return "";
        }
        String string6 = this.httpMain.getRequestParameter(object, "event");
        if (string6 != null) {
            jaxcentConnection.onEvent(string6);
            return "";
        }
        string6 = this.httpMain.getRequestParameter(object, "formdata");
        if (string6 != null) {
            jaxcentConnection.onFormData(string6);
        }
        if ((string6 = this.httpMain.getRequestParameter(object, "unload")) != null && string6.equals("1")) {
            this.context.disconnect(jaxcentConnection);
            return "";
        }
        string6 = this.httpMain.getRequestParameter(object, "load");
        if (string6 != null && string6.equals("1")) {
            jaxcentConnection.onLoad();
        }
        if ((stringArray = this.httpMain.getRequestParameterValues(object, "response")) != null && stringArray.length > 0) {
            jaxcentConnection.onResponse(stringArray);
        }
        String[] stringArray3 = this.httpMain.getRequestParameterValues(object, "error");
        string6 = this.httpMain.getRequestParameter(object, "formnames");
        if (string6 != null) {
            jaxcentConnection.onFormNames(string6);
        }
        if ((string6 = this.httpMain.getRequestParameter(object, "request")) != null) {
            jaxcentConnection.onPageRequest(string6);
            return "";
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            jaxcentConnection.onError(stringArray3);
        }
        return "jaxcent&" + jaxcentConnection.getId() + "&" + jaxcentConnection.getNextQuery(this.keepAliveTimeout);
    }

    public long getConnectionLostTimeout() {
        return this.connectionLostTimeout;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public ClassLoader getClassLoader() {
        return this.httpMain.getClassLoader();
    }

    public Object getAppContext() {
        return this.httpMain.getAppContext();
    }

    public Object getSession(Object object, boolean bl) {
        return this.httpMain.getSession(object, bl);
    }

    public synchronized Hashtable getJaxcentHashtable(Object object, boolean bl) {
        return this.httpMain.getJaxcentHashtable(object, bl);
    }
}

