/*
 * Decompiled with CFR 0.152.
 */
package jaxcentConnector;

import java.util.Enumeration;
import java.util.Hashtable;
import jaxcentConnector.JaxcentSession;

public class JaxcentAppContext {
    Hashtable table = new Hashtable(5);
    Hashtable initTable = new Hashtable(5);
    Hashtable sessions = new Hashtable(20);
    int sessionInactivityDefaultTimeout = 600;

    JaxcentAppContext(String[] stringArray, String[] stringArray2) {
        Object object;
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
                this.initTable.put(stringArray[i], stringArray2[i]);
            }
        }
        if ((object = this.getAttribute("SessionInactivityTimeout")) != null && object instanceof String) {
            try {
                int n = Integer.parseInt((String)object);
                if (n < 2) {
                    n = 2;
                }
                if (n > 7200) {
                    n = 7200;
                }
                this.sessionInactivityDefaultTimeout = n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setSessionAccessed(String string) {
        if (string == null) {
            return;
        }
        JaxcentSession jaxcentSession = (JaxcentSession)this.sessions.get(string);
        if (jaxcentSession != null) {
            jaxcentSession.setLastAccessedTime();
        }
    }

    void checkSessions() {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JaxcentSession jaxcentSession = (JaxcentSession)this.sessions.get(string);
            if (jaxcentSession == null || jaxcentSession.accessedAt + 1000L * (long)jaxcentSession.inactiveInterval >= System.currentTimeMillis()) continue;
            this.removeSession(string);
        }
    }

    void removeSession(String string) {
        this.sessions.remove(string);
    }

    public Object getAttribute(String string) {
        return this.table.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.table.keys();
    }

    public String getInitParameter(String string) {
        return (String)this.initTable.get(string);
    }

    public Enumeration getInitParameterNames() {
        return this.initTable.keys();
    }

    public void removeAttribute(String string) {
        this.table.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.table.put(string, object);
    }

    JaxcentSession getSession(String string) {
        if (string == null) {
            return null;
        }
        return (JaxcentSession)this.sessions.get(string);
    }

    JaxcentSession createSession(String string) {
        JaxcentSession jaxcentSession = new JaxcentSession(string, this.sessionInactivityDefaultTimeout, this);
        this.sessions.put(string, jaxcentSession);
        return jaxcentSession;
    }
}

