/*
 * $Id:ImageElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.test.frame.layer.image;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.test.AbstractConfigurableExtensionConfigElementTest;
import net.sf.jame.twister.TwisterRegistry;
import net.sf.jame.twister.extensions.frame.layer.image.BlackConfig;
import net.sf.jame.twister.extensions.frame.layer.image.ColorConfig;
import net.sf.jame.twister.frame.layer.image.ImageExtensionReferenceNodeValue;
import net.sf.jame.twister.frame.layer.image.extension.ImageExtensionConfig;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class ImageElementTest extends AbstractConfigurableExtensionConfigElementTest<ImageExtensionConfig> {
	@Override
	protected Node createElementNode() {
		return new ConfigurableExtensionReferenceNode<ImageExtensionConfig>("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<ImageExtensionConfig> value) {
				return new ImageExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ConfigurableExtensionConfigElement<ImageExtensionConfig> createConfigElement(final ConfigurableExtensionReference<ImageExtensionConfig> defaultValue) {
		final ConfigurableExtensionConfigElement<ImageExtensionConfig> configElement = new ConfigurableExtensionConfigElement<ImageExtensionConfig>();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLExporter<ImageExtensionConfig> createXMLExporter() {
		return new ConfigurableExtensionConfigElementXMLExporter<ImageExtensionConfig>();
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLImporter<ImageExtensionConfig> createXMLImporter() {
		return new ConfigurableExtensionConfigElementXMLImporter<ImageExtensionConfig>(TwisterRegistry.getInstance().getImageRegistry());
	}

	@Override
	protected ConfigurableExtensionReference<ImageExtensionConfig> getFirstReference() {
		final ConfigurableExtensionReference<ImageExtensionConfig> reference = new ConfigurableExtensionReference<ImageExtensionConfig>("twister.frame.layer.image.black", "Black", new BlackConfig());
		return reference;
	}

	@Override
	protected ConfigurableExtensionReference<ImageExtensionConfig> getSecondReference() {
		final ConfigurableExtensionReference<ImageExtensionConfig> reference = new ConfigurableExtensionReference<ImageExtensionConfig>("twister.frame.layer.image.color", "Color", new ColorConfig());
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
