/*
 * $Id:ConfigPanelTest.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.test.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import net.sf.jame.core.config.DefaultConfigContext;
import net.sf.jame.core.tree.NodeAction;
import net.sf.jame.core.tree.NodeSession;
import net.sf.jame.launcher.Launcher;
import net.sf.jame.runtime.LauncherContextListener;
import net.sf.jame.runtime.LauncherThreadFactory;
import net.sf.jame.twister.IntegerVector2D;
import net.sf.jame.twister.TwisterConfig;
import net.sf.jame.twister.TwisterConfigBuilder;
import net.sf.jame.twister.TwisterConfigNodeBuilder;
import net.sf.jame.twister.TwisterTree;
import net.sf.jame.twister.renderer.RenderContext;
import net.sf.jame.twister.swing.ConfigFrame;
import net.sf.jame.twister.swing.TwisterContext;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class ConfigPanelTest {
	private final Launcher<TwisterContext> launcher = new Launcher<TwisterContext>(new TestTwisterContext(), new TestThreadFactory());

	@Test
	public void testConfigPanel() {
		try {
			launcher.init();
			launcher.start();
			launcher.dispatch();
			launcher.dispose();
		}
		catch (final Exception e) {
			e.printStackTrace();
		}
	}

	private class TestThreadFactory implements LauncherThreadFactory<TwisterContext> {
		public Thread createThread(final TwisterContext context) {
			final Thread thread = new Thread(new Runnable() {
				public void run() {
					try {
						try {
							UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
						}
						catch (Exception x) {
							x.printStackTrace();
						}
						final NodeSession session = new TestNodeSesion();
						final TwisterTree twisterTree = new TwisterTree();
						TwisterConfigBuilder builder = new TwisterConfigBuilder();
						TwisterConfig config = builder.createDefaultConfig();
						config.setContext(new DefaultConfigContext());
						final TwisterConfigNodeBuilder nodeBuilder = new TwisterConfigNodeBuilder(config);
						twisterTree.getRootNode().setContext(config.getContext());
						twisterTree.getRootNode().setSession(session);
						nodeBuilder.createNodes(twisterTree.getRootNode());
						final ConfigFrame frame = new ConfigFrame(config, twisterTree, new TestRenderContext(), session);
						frame.addWindowListener(new WindowAdapter() {
							@Override
							public void windowClosing(WindowEvent e) {
								context.exit();
							}
						});
						SwingUtilities.invokeLater(new Runnable() {
							public void run() {
								frame.setVisible(true);
							}
						});
					}
					catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
			return thread;
		}
	}

	private class TestTwisterContext implements TwisterContext {
		/**
		 * @see net.sf.jame.twister.swing.TwisterContext#addFrame(javax.swing.JFrame)
		 */
		public void addFrame(final JFrame frame) {
		}

		/**
		 * @see net.sf.jame.twister.swing.TwisterContext#exit()
		 */
		public void exit() {
			launcher.stop();
		}

		/**
		 * @see net.sf.jame.twister.swing.TwisterContext#getFrameCount()
		 */
		public int getFrameCount() {
			return 0;
		}

		/**
		 * @see net.sf.jame.twister.swing.TwisterContext#removeFrame(javax.swing.JFrame)
		 */
		public void removeFrame(final JFrame frame) {
		}

		/**
		 * @see net.sf.jame.twister.swing.TwisterContext#restart()
		 */
		public void restart() {
			launcher.stop();
		}

		/**
		 * @see net.sf.jame.runtime.LauncherContext#setContextListener(net.sf.jame.runtime.LauncherContextListener)
		 */
		public void setContextListener(LauncherContextListener listener) {
		}
	}

	private class TestRenderContext implements RenderContext {
		/**
		 * @see net.sf.jame.twister.renderer.RenderContext#startRenderers()
		 */
		public void startRenderers() {
		}

		/**
		 * @see net.sf.jame.twister.renderer.RenderContext#stopRenderers()
		 */
		public void stopRenderers() {
		}

		/**
		 * @see net.sf.jame.twister.renderer.RenderContext#getImageSize()
		 */
		public IntegerVector2D getImageSize() {
			return new IntegerVector2D(100, 100);
		}

		/**
		 * @see net.sf.jame.twister.renderer.RenderContext#refresh()
		 */
		public void refresh() {
		}
	}

	private class TestNodeSesion implements NodeSession {
		/**
		 * @see net.sf.jame.core.tree.NodeSession#appendAction(net.sf.jame.core.tree.NodeAction)
		 */
		public void appendAction(final NodeAction action) {
			System.out.println(action);
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#getActions()
		 */
		public List<NodeAction> getActions() {
			return null;
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#getSessionName()
		 */
		public String getSessionName() {
			return "Test";
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#getTimestamp()
		 */
		public long getTimestamp() {
			return 0;
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#isAcceptImmediatly()
		 */
		public boolean isAcceptImmediatly() {
			return true;
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#setAcceptImmediatly(boolean)
		 */
		public void setAcceptImmediatly(final boolean isApplyImmediatly) {
		}

		/**
		 * @see net.sf.jame.core.tree.NodeSession#setTimestamp(long)
		 */
		public void setTimestamp(final long timestamp) {
			System.out.println("Timestamp = " + timestamp);
		}
	}
}
