/*
 * $Id:ExtensionConfigXMLImporter.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.util;

import java.util.List;

import net.sf.jame.core.extension.Extension;
import net.sf.jame.core.extension.ExtensionConfig;
import net.sf.jame.core.extension.ExtensionException;
import net.sf.jame.core.xml.XML;
import net.sf.jame.core.xml.XMLExporter;
import net.sf.jame.core.xml.XMLImportException;
import net.sf.jame.core.xml.XMLImporter;
import net.sf.jame.twister.TwisterRegistry;
import net.sf.jame.twister.xmlimport.extension.ExtensionConfigXMLImporterExtensionRuntime;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class ExtensionConfigXMLImporter<V extends ExtensionConfig> extends XMLImporter<V> {
	/**
	 * 
	 */
	public ExtensionConfigXMLImporter() {
	}

	/**
	 * @see net.sf.jame.core.xml.XMLImporter#importFromElement(org.w3c.dom.Element)
	 */
	@Override
	public V importFromElement(final Element element) throws XMLImportException {
		checkClassId(element, "reference");
		final List<Element> propertyElements = getProperties(element);
		if (propertyElements.size() == 1) {
			try {
				return importProperties(propertyElements, getExtensionId(element));
			}
			catch (final ExtensionException e) {
				throw new XMLImportException(e);
			}
		}
		return null;
	}

	/**
	 * @param propertyElements
	 * @param extensionId
	 * @throws ExtensionException
	 * @throws XMLImportException
	 * @return
	 */
	protected V importProperties(final List<Element> propertyElements, final String extensionId) throws ExtensionException, XMLImportException {
		return this.importReference(propertyElements.get(0), extensionId);
	}

	/**
	 * @param element
	 * @param extensionId
	 * @throws ExtensionException
	 * @throws XMLImportException
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected V importReference(final Element element, final String extensionId) throws ExtensionException, XMLImportException {
		final List<Element> configElements = XML.getElementsByName(element, XMLExporter.ELEMENT_TAG_NAME);
		if (configElements.size() == 1) {
			final Extension<ExtensionConfigXMLImporterExtensionRuntime> importerExtension = TwisterRegistry.getInstance().getXMLExtensionConfigImporterExtension(extensionId);
			final XMLImporter<V> importer = (XMLImporter<V>) importerExtension.createExtensionRuntime().createXMLImporter();
			return importer.importFromElement(configElements.get(0));
		}
		return null;
	}
}
