/*
 * $Id:ImageLayerConfigElementXMLImporter.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.frame.layer;

import java.util.List;

import net.sf.jame.core.xml.XMLImportException;
import net.sf.jame.twister.common.StringElement;
import net.sf.jame.twister.common.StringElementXMLImporter;
import net.sf.jame.twister.frame.layer.filter.LayerFilterConfigElement;
import net.sf.jame.twister.frame.layer.filter.LayerFilterConfigElementXMLImporter;
import net.sf.jame.twister.frame.layer.image.ImageConfigElement;
import net.sf.jame.twister.frame.layer.image.ImageConfigElementXMLImporter;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class ImageLayerConfigElementXMLImporter extends AbstractLayerConfigElementXMLImporter<ImageLayerConfigElement> {
	/**
	 * @see net.sf.jame.twister.frame.layer.AbstractLayerConfigElementXMLImporter#createConfigElement()
	 */
	@Override
	protected ImageLayerConfigElement createConfigElement() {
		return new ImageLayerConfigElement();
	}

	/**
	 * @see net.sf.jame.twister.frame.layer.AbstractLayerConfigElementXMLImporter#getConfigElementId()
	 */
	@Override
	protected String getConfigElementId() {
		return ImageLayerConfigElement.CLASS_ID;
	}

	/**
	 * @see net.sf.jame.core.xml.XMLImporter#importFromElement(org.w3c.dom.Element)
	 */
	@Override
	public ImageLayerConfigElement importFromElement(final Element element) throws XMLImportException {
		checkClassId(element, getConfigElementId());
		final ImageLayerConfigElement configElement = createConfigElement();
		final List<Element> propertyElements = getProperties(element);
		if (isVersion(element, 1) && propertyElements.size() == getPropertiesSize() + 3) {
			importProperties1(configElement, propertyElements);
		}
		else if (isVersion(element, 0) && propertyElements.size() == getPropertiesSize() + 1) {
			importProperties0(configElement, propertyElements);
		}
		return configElement;
	}

	protected void importProperties0(final ImageLayerConfigElement configElement, final List<Element> propertyElements) throws XMLImportException {
		super.importProperties(configElement, propertyElements);
		if (propertyElements.size() == getPropertiesSize() + 1) { // for backward compatibility
			importImage(configElement, propertyElements.get(getPropertiesSize() + 0));
		}
		else if (propertyElements.size() > getPropertiesSize() + 1) {
			importFilters(configElement, propertyElements.get(getPropertiesSize() + 0));
			importImage(configElement, propertyElements.get(getPropertiesSize() + 1));
		}
	}

	protected void importProperties1(final ImageLayerConfigElement configElement, final List<Element> propertyElements) throws XMLImportException {
		super.importProperties(configElement, propertyElements);
		importFilters(configElement, propertyElements.get(getPropertiesSize() + 0));
		importImage(configElement, propertyElements.get(getPropertiesSize() + 1));
		importLabel(configElement, propertyElements.get(getPropertiesSize() + 2));
	}

	private void importFilters(final ImageLayerConfigElement configElement, final Element element) throws XMLImportException {
		final LayerFilterConfigElementXMLImporter filterImporter = new LayerFilterConfigElementXMLImporter();
		final List<Element> filterElements = this.getElements(element, LayerFilterConfigElement.CLASS_ID);
		for (int i = 0; i < filterElements.size(); i++) {
			configElement.appendFilterConfigElement(filterImporter.importFromElement(filterElements.get(i)));
		}
	}

	private void importImage(final ImageLayerConfigElement configElement, final Element element) throws XMLImportException {
		final List<Element> imageElements = this.getElements(element, ImageConfigElement.CLASS_ID);
		if (imageElements.size() == 1) {
			configElement.setImageConfigElement(new ImageConfigElementXMLImporter().importFromElement(imageElements.get(0)));
		}
	}

	private void importLabel(final ImageLayerConfigElement configElement, final Element element) throws XMLImportException {
		final List<Element> stringElements = this.getElements(element, StringElement.CLASS_ID);
		if (stringElements.size() == 1) {
			configElement.setLabel(new StringElementXMLImporter().importFromElement(stringElements.get(0)).getValue());
		}
	}
}
