/*
 * $Id:ComplexElement.java 480 2008-01-24 21:15:43Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.common;

import net.sf.jame.core.config.ValueConfigElement;
import net.sf.jame.twister.DoubleVector2D;

/**
 * @author Andrea Medeghini
 */
public class ComplexElement extends ValueConfigElement<DoubleVector2D> {
	public static final String CLASS_ID = "Complex";
	private static final long serialVersionUID = 1L;

	/**
	 * @param defaultValue
	 */
	public ComplexElement(final DoubleVector2D defaultValue) {
		super(ComplexElement.CLASS_ID, defaultValue);
	}

	/**
	 * @see net.sf.jame.core.config.ValueConfigElement#clone()
	 */
	@Override
	public ComplexElement clone() {
		return new ComplexElement(getValue().clone());
	}
}
