/*
 * $Id:TestRenderProfileFileCache.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.test;

import java.io.File;

import net.sf.jame.service.ConnectionFactory;
import net.sf.jame.service.DefaultConnectionFactory;
import net.sf.jame.service.Session;
import net.sf.jame.service.profile.RenderProfile;
import net.sf.jame.service.profile.RenderProfileDataRow;
import net.sf.jame.service.profile.RenderProfileFileCache;

import org.junit.Assert;
import org.junit.Test;

public class TestRenderProfileFileCache {
	private int lastId = 1;

	@Test
	public void testCreate() {
		try {
			final RenderProfileFileCache fileCache = new RenderProfileFileCache(new File("workdir/profile"));
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			fileCache.deleteAll();
			fileCache.create(createProfile().getProfileId());
			fileCache.create(createProfile().getProfileId());
			fileCache.create(createProfile().getProfileId());
			fileCache.create(createProfile().getProfileId());
			final File[] profiles = fileCache.list();
			printClips(profiles);
			Assert.assertEquals(4, profiles.length);
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	@Test
	public void testDelete() {
		try {
			final RenderProfileFileCache fileCache = new RenderProfileFileCache(new File("workdir/profile"));
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			fileCache.deleteAll();
			final RenderProfileDataRow profile = createProfile();
			fileCache.create(profile.getProfileId());
			fileCache.delete(profile.getProfileId());
			final File[] profiles = fileCache.list();
			Assert.assertEquals(0, profiles.length);
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	private RenderProfileDataRow createProfile() {
		final RenderProfileDataRow profile = new RenderProfileDataRow(new RenderProfile());
		profile.setProfileId(lastId);
		profile.setProfileName("Test Name");
		profile.setClipId(1);
		profile.setImageWidth(320);
		profile.setImageHeight(200);
		profile.setFrameRate(0);
		profile.setStartTime(0);
		profile.setStopTime(0);
		profile.setQuality(100);
		lastId += 1;
		return profile;
	}

	private void printClips(final File[] profiles) {
		for (final File profile : profiles) {
			System.out.println(profile);
		}
	}
}
