/*
 * $Id:JobEvent.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.spool;

import java.io.Serializable;

/**
 * @author Andrea Medeghini
 */
public class JobEvent implements Serializable {
	private static final long serialVersionUID = 1L;
	public static final int EVENT_TYPE_STATUS = 10;
	public static final int EVENT_TYPE_START = 20;
	public static final int EVENT_TYPE_STOP = 30;
	private final int eventType;
	private final Serializable eventData;

	/**
	 * @param eventType
	 * @param eventData
	 */
	public JobEvent(final int eventType, final Serializable eventData) {
		this.eventType = eventType;
		this.eventData = eventData;
	}

	/**
	 * @return the eventType
	 */
	public int getEventType() {
		return eventType;
	}

	/**
	 * @return the eventData
	 */
	public Serializable getEventData() {
		return eventData;
	}

	/**
	 * @param eventType
	 * @return
	 */
	public static final String decodeEventType(final int eventType) {
		switch (eventType) {
			case EVENT_TYPE_START:
				return "START";
			case EVENT_TYPE_STOP:
				return "STOP";
			case EVENT_TYPE_STATUS:
				return "STATUS";
			default:
				return "unknown";
		}
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("[");
		builder.append("eventType = ");
		builder.append(decodeEventType(getEventType()));
		builder.append(", eventData = ");
		builder.append("[");
		builder.append(eventData);
		builder.append("]");
		builder.append("]");
		return builder.toString();
	}
}
