/*
 * $Id:RenderProfileFileCache.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.profile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

import net.sf.jame.service.FileCache;
import net.sf.jame.service.util.BINFilenameFilter;

/**
 * @author Andrea Medeghini
 */
public class RenderProfileFileCache extends FileCache {
	/**
	 * @param workdir
	 * @throws IOException
	 */
	public RenderProfileFileCache(final File workdir) throws IOException {
		super(workdir);
	}

	/**
	 * @see net.sf.jame.service.FileCache#getFileName(int)
	 */
	@Override
	public String getFileName(final int profileId) {
		return String.valueOf(profileId);
	}

	/**
	 * @see net.sf.jame.service.FileCache#createFileFilter()
	 */
	@Override
	protected FilenameFilter createFileFilter() {
		return new BINFilenameFilter();
	}

	/**
	 * @see net.sf.jame.service.FileCache#getSuffix()
	 */
	@Override
	public String getSuffix() {
		return BINFilenameFilter.getSuffix();
	}
}
