/*
 * $Id:AbstractEncoderExtensionRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.extensions.encoder;

import java.util.ArrayList;
import java.util.List;

import net.sf.jame.service.ProgressListener;
import net.sf.jame.service.encoder.extension.EncoderExtensionConfig;
import net.sf.jame.service.encoder.extension.EncoderExtensionRuntime;

/**
 * @author Andrea Medeghini
 */
public abstract class AbstractEncoderExtensionRuntime<T extends EncoderExtensionConfig> extends EncoderExtensionRuntime<T> {
	private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();

	/**
	 * @see net.sf.jame.service.encoder.extension.EncoderExtensionRuntime#addProgressListener(net.sf.jame.service.ProgressListener)
	 */
	@Override
	public void addProgressListener(final ProgressListener listener) {
		this.listeners.add(listener);
	}

	/**
	 * @see net.sf.jame.service.encoder.extension.EncoderExtensionRuntime#removeProgressListener(net.sf.jame.service.ProgressListener)
	 */
	@Override
	public void removeProgressListener(final ProgressListener listener) {
		this.listeners.remove(listener);
	}

	/**
	 * @param percent
	 */
	protected void fireStatusChanged(final int percent) {
		for (final ProgressListener listener : this.listeners) {
			listener.statusChanged(percent);
		}
	}

	/**
	 * @see net.sf.jame.core.extension.ExtensionRuntime#dispose()
	 */
	@Override
	public void dispose() {
	}
}
