/*
 * $Id:ServiceListener.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service;

import net.sf.jame.service.clip.MovieClipDataRow;
import net.sf.jame.service.job.RenderJobDataRow;
import net.sf.jame.service.profile.RenderProfileDataRow;

/**
 * @author Andrea Medeghini
 */
public interface ServiceListener {
	/**
	 * @param clip
	 */
	public void clipCreated(MovieClipDataRow clip);

	/**
	 * @param clip
	 */
	public void clipDeleted(MovieClipDataRow clip);

	/**
	 * @param clip
	 */
	public void clipUpdated(MovieClipDataRow clip);

	/**
	 * @param profile
	 */
	public void profileCreated(RenderProfileDataRow profile);

	/**
	 * @param profile
	 */
	public void profileDeleted(RenderProfileDataRow profile);

	/**
	 * @param profile
	 */
	public void profileUpdated(RenderProfileDataRow profile);

	/**
	 * @param job
	 */
	public void jobCreated(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobDeleted(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobUpdated(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobStarted(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobAborted(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobStopped(RenderJobDataRow job);

	/**
	 * @param job
	 */
	public void jobResumed(RenderJobDataRow job);
}
