/*
 * $Id:DefaultConnectionFactory.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;

/**
 * @author Andrea Medeghini
 */
public class DefaultConnectionFactory implements ConnectionFactory {
	private static final Logger logger = Logger.getLogger(DefaultConnectionFactory.class);
	private final String databaseDriver;
	private String databaseUrl;

	/**
	 * @param workspace
	 */
	public DefaultConnectionFactory(final File workspace) {
		final ResourceBundle bundle = ResourceBundle.getBundle("net.sf.jame.service.database");
		databaseDriver = bundle.getString("database.driver");
		databaseUrl = bundle.getString("database.url");
		databaseUrl = databaseUrl.replace("${workspace}", workspace.getAbsolutePath());
		try {
			Class.forName(databaseDriver);
		}
		catch (final ClassNotFoundException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see net.sf.jame.service.ConnectionFactory#createConnection()
	 */
	public Connection createConnection() throws SQLException {
		if (DefaultConnectionFactory.logger.isDebugEnabled()) {
			DefaultConnectionFactory.logger.debug("Create a connection");
		}
		return DriverManager.getConnection(databaseUrl);
	}
}
