/*
 * $Id:DummySpoolJobService.java 474 2008-01-13 18:30:34Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.test;

import java.io.File;

import net.sf.jame.networking.jxta.JXTADiscoveryService;
import net.sf.jame.networking.jxta.JXTANetworkService;
import net.sf.jame.networking.jxta.JXTASpoolJobService;
import net.sf.jame.networking.spool.DistributedServiceProcessor;
import net.sf.jame.service.spool.JobFactory;
import net.sf.jame.service.spool.JobInterface;
import net.sf.jame.service.spool.JobListener;

import org.apache.log4j.Logger;

/**
 * @author Andrea Medeghini
 */
public class DummySpoolJobService {
	private static final Logger logger = Logger.getLogger(DummySpoolJobService.class);

	/**
	 * @param args
	 */
	public static void main(final String args[]) {
		final File tmpDir = new File("workdir/tmp");
		final DistributedServiceProcessor processor1 = new DistributedServiceProcessor(new DummyJobService<DummyJob>(new ProcessorJobFactory()), 10);
		final DistributedServiceProcessor processor2 = new DistributedServiceProcessor(new DummyJobService<DummyJob>(new ProcessorJobFactory()), 10);
		final JXTASpoolJobService service = new JXTASpoolJobService(new JXTADiscoveryService(new JXTANetworkService(tmpDir, "http://jame.sf.net", "JAME-Service", "Andrea Medeghini", "1.0", processor1), processor2), new SpoolJobFactory());
		service.start();
		processor1.start();
		processor2.start();
		try {
			for (int i = 0; i < 50; i++) {
				final String jobId = service.createJob(new TestListener());
				logger.debug("Job " + i + " runned, jobId = " + jobId);
				service.runJob(jobId);
			}
			while (true) {
				Thread.sleep(10000);
			}
		}
		catch (final InterruptedException e) {
		}
		processor1.stop();
		processor2.stop();
		service.stop();
	}

	private static class TestListener implements JobListener {
		/**
		 * @see net.sf.jame.service.spool.JobListener#stateChanged(net.sf.jame.networking.test.DummyJob)
		 */
		public void stateChanged(final JobInterface job) {
			logger.debug("Job state changed " + job);
		}

		/**
		 * @see net.sf.jame.service.spool.JobListener#started(net.sf.jame.networking.test.DummyJob)
		 */
		public void started(final JobInterface job) {
			logger.debug("Job started " + job);
		}

		/**
		 * @see net.sf.jame.service.spool.JobListener#stopped(net.sf.jame.networking.test.DummyJob)
		 */
		public void stopped(final JobInterface job) {
			logger.debug("Job stopped " + job);
		}

		/**
		 * @see net.sf.jame.service.spool.JobListener#terminated(net.sf.jame.service.spool.JobInterface)
		 */
		public void terminated(final JobInterface job) {
			logger.debug("Job terminated " + job);
		}
	}

	private static class ProcessorJobFactory implements JobFactory<DummyJob> {
		/**
		 * @see net.sf.jame.service.spool.JobFactory#createJob(java.lang.String, net.sf.jame.service.spool.JobListener)
		 */
		public DummyJob createJob(final String jobId, final JobListener listener) {
			final byte[] dataIn = new byte[128];
			final byte[] dataOut = new byte[128];
			final DummyJob job = new DummyJob(dataIn, dataOut, listener);
			job.setJobId(jobId);
			return job;
		}
	}

	private static class SpoolJobFactory implements JobFactory<DummyRemoteJob> {
		/**
		 * @see net.sf.jame.service.spool.RemoteJobFactory#createJob(java.lang.String, net.sf.jame.service.spool.JobListener)
		 */
		public DummyRemoteJob createJob(final String jobId, final JobListener listener) {
			final byte[] dataIn = new byte[128];
			final byte[] dataOut = new byte[128];
			final DummyRemoteJob job = new DummyRemoteJob(dataIn, dataOut, listener);
			job.setJobId(jobId);
			return job;
		}
	}
}
