/*
 * $Id:ServiceLauncherThread.java 474 2008-01-13 18:30:34Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.jxta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import net.sf.jame.networking.spool.DistributedServiceProcessor;
import net.sf.jame.runtime.LauncherContext;
import net.sf.jame.runtime.LauncherContextListener;
import net.sf.jame.service.ConnectionFactory;
import net.sf.jame.service.DefaultConnectionFactory;
import net.sf.jame.service.spool.DefaultJobService;
import net.sf.jame.service.spool.impl.DistributedJob;
import net.sf.jame.service.spool.impl.DistributedJobFactory;

import org.apache.log4j.PropertyConfigurator;

/**
 * @author Andrea Medeghini
 */
public class ServiceLauncherThread extends Thread implements LauncherContextListener {
	private DistributedServiceProcessor processor;
	private JXTANetworkService service;
	private final LauncherContext context;
	
	/**
	 * @param context
	 */
	public ServiceLauncherThread(final LauncherContext context) {
		super("Launcher");
		this.context = context;
		context.setContextListener(this);
	}

	/**
	 * @see java.lang.Thread#run()
	 */
	@Override
	public void run() {
		try {
			final Properties properties = new Properties();
			File workspace = null;
			try {
				properties.load(new FileInputStream(System.getProperty("user.home") + "/JXTASpool.properties"));
				if (properties.get("workspace") == null || System.getProperty("jame.workspace") != null) {
					workspace = new File(System.getProperty("jame.workspace", System.getProperty("user.home") + "/JXTASpool-workspace"));
					properties.put("workspace", workspace.getAbsolutePath());
					try {
						properties.store(new FileOutputStream(System.getProperty("user.home") + "/JXTASpool.properties"), null);
					}
					catch (final Exception e) {
						e.printStackTrace();
					}
				}
				else {
					workspace = new File((String) properties.get("workspace"));
				}
			}
			catch (final Exception x) {
				x.printStackTrace();
				workspace = new File(System.getProperty("jame.workspace", System.getProperty("user.home") + "/JXTASpool-workspace"));
				properties.put("workspace", workspace.getAbsolutePath());
				try {
					properties.store(new FileOutputStream(System.getProperty("user.home") + "/JXTASpool.properties"), null);
				}
				catch (final Exception e) {
					e.printStackTrace();
				}
			}
			ConnectionFactory connectionFactory = null;
			while (workspace != null) {
				connectionFactory = new DefaultConnectionFactory(workspace);
				final Connection connection = null;
				try {
					connectionFactory.createConnection();
					break;
				}
				catch (final Exception e) {
					e.printStackTrace();
					workspace = null;
				}
				finally {
					if (connection != null) {
						try {
							connection.close();
						}
						catch (final SQLException e) {
						}
					}
				}
			}
			if (workspace != null) {
				Properties log4jProperties = new Properties();
				log4jProperties.put("log4j.rootLogger", "INFO, file, console");
				log4jProperties.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
				log4jProperties.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
				log4jProperties.put("log4j.appender.console.layout.ConversionPattern", "%d{HH:mm:ss,SSS} %-5p %c - %m%n");
				log4jProperties.put("log4j.appender.file", "org.apache.log4j.FileAppender");
				log4jProperties.put("log4j.appender.file.file", workspace.getAbsolutePath() + "/JXTASpool.log");
				log4jProperties.put("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
				log4jProperties.put("log4j.appender.file.layout.ConversionPattern", "%d{HH:mm:ss,SSS} %-5p %c - %m%n");
				log4jProperties.put("log4j.logger.net.sf.jame", "INFO");
				log4jProperties.put("log4j.logger.org.apache.derby", "INFO");
				try {
					log4jProperties.load(new FileInputStream("log4j.properties"));
				}
				catch (Exception e) {
					e.printStackTrace();
				}
				PropertyConfigurator.configure(log4jProperties);
				final File tmpDir = new File(workspace, "/JXTASpool");
				tmpDir.mkdirs();
				deleteFiles(tmpDir);
				processor = new DistributedServiceProcessor(new DefaultJobService<DistributedJob>(new DistributedJobFactory(tmpDir)), 10);
				service = new JXTANetworkService(tmpDir, "http://jame.sf.net", "JAME-Service", "Andrea Medeghini", "1.0", processor);
				service.start();
				processor.start();
			}
		}
		catch (final Exception e) {
			e.printStackTrace();
			context.exit();
		}
	}
	
	private void deleteFiles(final File path) {
		final File[] files = path.listFiles();
		for (final File file : files) {
			if (file.isDirectory()) {
				deleteFiles(file);
			}
			file.delete();
		}
	}

	/**
	 * @see net.sf.jame.runtime.LauncherContextListener#started()
	 */
	public void started() {
	}

	/**
	 * @see net.sf.jame.runtime.LauncherContextListener#stopped()
	 */
	public void stopped() {
		service.stop();
		processor.stop();
	}
}
