/*
 * $Id:JXTAServiceEndpoint.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.jxta;

import net.jxta.id.ID;
import net.jxta.protocol.PipeAdvertisement;
import net.sf.jame.networking.ServiceEndpoint;
import net.sf.jame.networking.ServiceException;
import net.sf.jame.networking.ServiceListener;
import net.sf.jame.networking.ServiceSession;

/**
 * @author Andrea Medeghini
 */
public class JXTAServiceEndpoint implements ServiceEndpoint {
	private final JXTANetworkService networkService;
	private final PipeAdvertisement pipeadv;
	private final String serviceName;

	/**
	 * @param networkService
	 * @param pipeadv
	 */
	public JXTAServiceEndpoint(final JXTANetworkService networkService, final PipeAdvertisement pipeadv) {
		serviceName = "RemoteService (pipeID = " + pipeadv.getPipeID() + ")";
		this.networkService = networkService;
		this.pipeadv = pipeadv;
	}

	/**
	 * @return the name
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("serviceName = ");
		builder.append(serviceName);
		return builder.toString();
	}

	/**
	 * @return
	 */
	public ID getPipeID() {
		return pipeadv.getPipeID();
	}

	/**
	 * @see net.sf.jame.networking.ServiceEndpoint#createSession(net.sf.jame.networking.ServiceListener)
	 */
	public ServiceSession createSession(final ServiceListener listener) throws ServiceException {
		return networkService.createSession(pipeadv, listener);
	}
}
