/*
 * $Id:JXTADiscoveryService.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.jxta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import net.jxta.id.ID;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.sf.jame.networking.DiscoveryService;
import net.sf.jame.networking.LocalService;
import net.sf.jame.networking.LocalServiceEndpoint;
import net.sf.jame.networking.ServiceEndpoint;
import net.sf.jame.networking.ServiceProcessor;

/**
 * @author Andrea Medeghini
 */
public class JXTADiscoveryService implements DiscoveryService {
	private final HashMap<ID, ServiceEndpoint> endpoints = new HashMap<ID, ServiceEndpoint>();
	private final JXTANetworkService networkService;
	private final LocalService localService;
	private final LocalServiceEndpoint localEndpoint;

	/**
	 * @param networkService
	 * @param processor
	 */
	public JXTADiscoveryService(final JXTANetworkService networkService, final ServiceProcessor processor) {
		this.networkService = networkService;
		localService = new LocalService("LOCAL", processor);
		localEndpoint = new LocalServiceEndpoint(localService);
	}

	/**
	 * @see net.sf.jame.networking.DiscoveryService#getEndpoints()
	 */
	public List<ServiceEndpoint> getEndpoints() {
		final List<ServiceEndpoint> tmpEndpoints = new ArrayList<ServiceEndpoint>();
		final List<ModuleSpecAdvertisement> serviceAdvertisements = networkService.getAdvertisements();
		for (final ModuleSpecAdvertisement serviceAdvertisement : serviceAdvertisements) {
			JXTAServiceEndpoint endpoint = (JXTAServiceEndpoint) endpoints.get(serviceAdvertisement.getPipeAdvertisement().getPipeID());
			if (endpoint == null) {
				endpoint = new JXTAServiceEndpoint(networkService, serviceAdvertisement.getPipeAdvertisement());
				endpoints.put(serviceAdvertisement.getPipeAdvertisement().getPipeID(), endpoint);
			}
			tmpEndpoints.add(endpoint);
		}
		endpoints.clear();
		for (final ServiceEndpoint service : tmpEndpoints) {
			endpoints.put(((JXTAServiceEndpoint) service).getPipeID(), service);
		}
		// tmpEndpoints.clear();
		tmpEndpoints.add(localEndpoint);
		return tmpEndpoints;
	}

	/**
	 * @see net.sf.jame.networking.DiscoveryService#start()
	 */
	public void start() {
		localService.start();
		networkService.start();
	}

	/**
	 * @see net.sf.jame.networking.DiscoveryService#stop()
	 */
	public void stop() {
		localService.stop();
		networkService.stop();
	}
}
