/*
 * $Id:MovieApplet.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;

import net.sf.jame.media.Context;
import net.sf.jame.media.Movie;

public abstract class MovieApplet extends Applet implements Context {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Engine engine;
	private Color color = Color.white;
	private boolean debug = false;
	private boolean loop = false;

	public final Color getColor() {
		return color;
	}

	public final boolean debug() {
		return debug;
	}

	public final boolean loop() {
		return loop;
	}

	public void println(final String s) {
		System.out.println(s);
	}

	public void print(final String s) {
		System.out.print(s);
	}

	public void exit(final int code) {
	}

	@Override
	public final void init() {
		if (engine == null) {
			final String par_color = getParameter("color");
			final String par_debug = getParameter("debug");
			final String par_loop = getParameter("loop");
			if (par_debug != null) {
				// System.out.println("debug = " + par_debug);
				if (par_debug.toLowerCase().equals("true")) {
					debug = true;
				}
			}
			if (par_loop != null) {
				// System.out.println("loop = " + par_loop);
				if (par_loop.toLowerCase().equals("true")) {
					loop = true;
				}
			}
			if (par_color != null) {
				// System.out.println("color = " + par_color);
				try {
					color = new Color(Integer.parseInt(par_color.substring(1), 16));
				}
				catch (final NumberFormatException e) {
				}
			}
			setBackground(color);
			setForeground(color);
			setIgnoreRepaint(true);
			setCursor(new Cursor(Cursor.HAND_CURSOR));
			final MovieCanvas canvas = new MovieCanvas(this);
			setLayout(new BorderLayout());
			this.add(canvas, BorderLayout.CENTER);
			canvas.requestFocus();
			engine = canvas.getEngine();
		}
	}

	@Override
	public final void start() {
		engine.start();
	}

	@Override
	public final void stop() {
		engine.stop();
	}

	@Override
	public final void destroy() {
	}

	public abstract Movie getMovie();
}
