/*
 * $Id:Color.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is based on code from idx3dIII
 * Copyright (C) 1999, 2000 Peter Walser, pwalser@idx3d.ch
 * http://www.idx3d.ch/idx3d/idx3d.html
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media.g3d;

public final class Color {
	public static final int MASK7Bit = 0xFEFEFF;
	public static final int ALPHA = 0xFF000000;
	public static final int RGB = 0xFFFFFF;

	private Color() {
	}

	public static int getRed(final int c) {
		return ((c >> 16) & 255);
	}

	public static int getGreen(final int c) {
		return ((c >> 8) & 255);
	}

	public static int getBlue(final int c) {
		return (c & 255);
	}

	public static int getCropColor(final int r, final int g, final int b) {
		return Color.ALPHA | (Math.crop(r, 0, 255) << 16) | (Math.crop(g, 0, 255) << 8) | Math.crop(b, 0, 255);
	}

	public static int getColor(final int r, final int g, final int b) {
		return Color.ALPHA | ((r & 255) << 16) | ((g & 255) << 8) | (b & 255);
	}

	public static int getGray(final int color) {
		final int r = ((color >> 16) & 255);
		final int g = ((color >> 8) & 255);
		final int b = (color & 255);
		final int Y = ((r * 3) + (g * 6) + b) / 10;
		return Color.ALPHA | (Y << 16) | (Y << 8) | Y;
	}

	public static int getAverage(final int color) {
		return (((color >> 16) & 255) + ((color >> 8) & 255) + (color & 255)) / 3;
	}

	public static int add(final int color1, final int color2) {
		final int c = (color1 & Color.MASK7Bit) + (color2 & Color.MASK7Bit);
		int overflow = c & 0x1010100;
		overflow = overflow - (overflow >> 8);
		return Color.ALPHA | (overflow | c);
	}

	public static int sub(final int color1, final int color2) {
		final int c = (color1 & Color.MASK7Bit) + (~color2 & Color.MASK7Bit);
		int overflow = ~c & 0x1010100;
		overflow = overflow - (overflow >> 8);
		return Color.ALPHA | (~overflow & c);
	}

	public static int inv(final int color) {
		return Color.ALPHA | (~color);
	}

	public static int scale(final int color, final int factor) {
		if (factor == 0) {
			return 0;
		}
		if (factor == 255) {
			return color;
		}
		if (factor == 127) {
			return (color & 0xFEFEFE) >> 1;
		}
		final int r = (((color >> 16) & 255) * factor) >> 8;
		final int g = (((color >> 8) & 255) * factor) >> 8;
		final int b = ((color & 255) * factor) >> 8;
		return Color.ALPHA | (r << 16) | (g << 8) | b;
	}

	public static int mul(final int color1, final int color2) {
		if ((color1 & Color.RGB) == 0) {
			return 0;
		}
		if ((color2 & Color.RGB) == 0) {
			return 0;
		}
		final int r = (((color1 >> 16) & 255) * ((color2 >> 16) & 255)) >> 8;
		final int g = (((color1 >> 8) & 255) * ((color2 >> 8) & 255)) >> 8;
		final int b = ((color1 & 255) * (color2 & 255)) >> 8;
		return Color.ALPHA | (r << 16) | (g << 8) | b;
	}

	public static int mix(final int color1, final int color2) {
		return Color.ALPHA | (((color1 & 0xFEFEFE) >> 1) + ((color2 & 0xFEFEFE) >> 1));
	}

	public static int mix(final int color1, final int color2, final int alpha) {
		if (alpha == 0) {
			return color2;
		}
		if (alpha == 255) {
			return color1;
		}
		if (alpha == 127) {
			return Color.mix(color1, color2);
		}
		final int r = ((alpha * (((color1 >> 16) & 255) - ((color2 >> 16) & 255))) >> 8) + ((color2 >> 16) & 255);
		final int g = ((alpha * (((color1 >> 8) & 255) - ((color2 >> 8) & 255))) >> 8) + ((color2 >> 8) & 255);
		final int b = ((alpha * ((color1 & 255) - (color2 & 255))) >> 8) + (color2 & 255);
		return Color.ALPHA | (r << 16) | (g << 8) | b;
	}

	public static final int random() {
		return (int) (java.lang.Math.random() * 16777216);
	}
}
