/*
 * $Id:ThresholdElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.test.common;

import net.sf.jame.core.tree.Node;
import net.sf.jame.mandelbrot.common.ThresholdElement;
import net.sf.jame.mandelbrot.common.ThresholdElementNode;
import net.sf.jame.mandelbrot.common.ThresholdElementXMLExporter;
import net.sf.jame.mandelbrot.common.ThresholdElementXMLImporter;
import net.sf.jame.test.AbsractValueElementTest;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class ThresholdElementTest extends AbsractValueElementTest<Double, ThresholdElement> {
	@Override
	protected Double getFirstValue() {
		return new Double(20);
	}

	@Override
	protected Double getSecondValue() {
		return new Double(40);
	}

	@Override
	protected ThresholdElement createConfigElement(final Double defaultValue) {
		final ThresholdElement configElement = new ThresholdElement(defaultValue);
		return configElement;
	}

	@Override
	protected Node createElementNode() {
		return new ThresholdElementNode("value", getConfigElement()) {
		};
	}

	@Override
	protected ThresholdElementXMLImporter createXMLImporter() {
		return new ThresholdElementXMLImporter();
	}

	@Override
	protected ThresholdElementXMLExporter createXMLExporter() {
		return new ThresholdElementXMLExporter();
	}

	@Override
	@Test
	public void testSetValue() {
		super.testSetValue();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}

	@Override
	@Test
	public void testActions() {
		super.testActions();
	}
}
