/*
 * $Id:ColorRendererFormulaElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.test.color.formula;

import net.sf.jame.core.extension.ExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotRegistry;
import net.sf.jame.mandelbrot.color.formula.ColorRendererFormulaExtensionReferenceNodeValue;
import net.sf.jame.test.AbstractExtensionConfigElementTest;
import net.sf.jame.twister.util.ExtensionConfigElement;
import net.sf.jame.twister.util.ExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class ColorRendererFormulaElementTest extends AbstractExtensionConfigElementTest {
	@Override
	protected Node createElementNode() {
		return new ExtensionReferenceNode("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ExtensionReference value) {
				return new ColorRendererFormulaExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ExtensionConfigElement createConfigElement(final ExtensionReference defaultValue) {
		final ExtensionConfigElement configElement = new ExtensionConfigElement();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ExtensionConfigElementXMLExporter createXMLExporter() {
		return new ExtensionConfigElementXMLExporter();
	}

	@Override
	protected ExtensionConfigElementXMLImporter createXMLImporter() {
		return new ExtensionConfigElementXMLImporter(MandelbrotRegistry.getInstance().getColorRendererFormulaRegistry());
	}

	@Override
	protected ExtensionReference getFirstReference() {
		final ExtensionReference reference = new ExtensionReference("twister.mandelbrot.color.renderer.formula.phase", "Phase");
		return reference;
	}

	@Override
	protected ExtensionReference getSecondReference() {
		final ExtensionReference reference = new ExtensionReference("twister.mandelbrot.color.renderer.formula.modulus", "Modulus");
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
